/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.Name;
import androidx.compose.lint.NamesKt;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/lifecycle/lint/ViewModelConstructorInComposableDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Companion", "lifecycle-viewmodel-compose-lint"})
public final class ViewModelConstructorInComposableDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Name FqViewModelName = NamesKt.Name(NamesKt.Package("androidx.lifecycle"), "ViewModel");
    @NotNull
    private static final Issue ISSUE = Issue.Companion.create("ViewModelConstructorInComposable", "Constructing a view model in a composable", "View models should not be constructed directly inside composable functions. Instead you should use the lifecycle viewmodel extensionfunctions e.g. viewModel<MyViewModel>()", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ViewModelConstructorInComposableDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!ComposableUtilsKt.isInvokedWithinComposable((UExpression)node)) {
                    return;
                }
                if (!UastExpressionUtils.isConstructorCall((UElement)((UElement)node))) {
                    return;
                }
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null || (psiMethod = psiMethod.getContainingClass()) == null) {
                    return;
                }
                PsiMethod containingClass = psiMethod;
                if (PsiUtilsKt.inheritsFrom((PsiClass)containingClass, ViewModelConstructorInComposableDetector.access$getFqViewModelName$cp())) {
                    JavaContext.report$default((JavaContext)this.$context, (Issue)ViewModelConstructorInComposableDetector.Companion.getISSUE(), (UElement)((UElement)node), (Location)this.$context.getNameLocation((UElement)node), (String)"Constructing a view model in a composable", null, (int)16, null);
                }
            }
        };
    }

    public static final /* synthetic */ Name access$getFqViewModelName$cp() {
        return FqViewModelName;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/lifecycle/lint/ViewModelConstructorInComposableDetector$Companion;", "", "()V", "FqViewModelName", "Landroidx/compose/lint/Name;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "lifecycle-viewmodel-compose-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

