/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.annotation.SuppressLint;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleController;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public final class SavedStateViewModelFactory
extends ViewModelProvider.KeyedFactory {
    private final Application mApplication;
    private final ViewModelProvider.AndroidViewModelFactory mFactory;
    private final Bundle mDefaultArgs;
    private final Lifecycle mLifecycle;
    private final SavedStateRegistry mSavedStateRegistry;
    private static final Class<?>[] ANDROID_VIEWMODEL_SIGNATURE = new Class[]{Application.class, SavedStateHandle.class};
    private static final Class<?>[] VIEWMODEL_SIGNATURE = new Class[]{SavedStateHandle.class};

    public SavedStateViewModelFactory(@NonNull Application application, @NonNull SavedStateRegistryOwner owner) {
        this(application, owner, null);
    }

    @SuppressLint(value={"LambdaLast"})
    public SavedStateViewModelFactory(@NonNull Application application, @NonNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs) {
        this.mSavedStateRegistry = owner.getSavedStateRegistry();
        this.mLifecycle = owner.getLifecycle();
        this.mDefaultArgs = defaultArgs;
        this.mApplication = application;
        this.mFactory = ViewModelProvider.AndroidViewModelFactory.getInstance((Application)application);
    }

    @NonNull
    public <T extends ViewModel> T create(@NonNull String key, @NonNull Class<T> modelClass) {
        boolean isAndroidViewModel = AndroidViewModel.class.isAssignableFrom(modelClass);
        Constructor<T> constructor = isAndroidViewModel ? SavedStateViewModelFactory.findMatchingConstructor(modelClass, ANDROID_VIEWMODEL_SIGNATURE) : SavedStateViewModelFactory.findMatchingConstructor(modelClass, VIEWMODEL_SIGNATURE);
        if (constructor == null) {
            return (T)this.mFactory.create(modelClass);
        }
        SavedStateHandleController controller = SavedStateHandleController.create(this.mSavedStateRegistry, this.mLifecycle, key, this.mDefaultArgs);
        try {
            ViewModel viewmodel = isAndroidViewModel ? (ViewModel)constructor.newInstance(this.mApplication, controller.getHandle()) : (ViewModel)constructor.newInstance(controller.getHandle());
            viewmodel.setTagIfAbsent("androidx.lifecycle.savedstate.vm.tag", (Object)controller);
            return (T)viewmodel;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to access " + modelClass, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("A " + modelClass + " cannot be instantiated.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("An exception happened in constructor of " + modelClass, e.getCause());
        }
    }

    @NonNull
    public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
        String canonicalName = modelClass.getCanonicalName();
        if (canonicalName == null) {
            throw new IllegalArgumentException("Local and anonymous classes can not be ViewModels");
        }
        return this.create(canonicalName, modelClass);
    }

    private static <T> Constructor<T> findMatchingConstructor(Class<T> modelClass, Class<?>[] signature) {
        for (Constructor<?> constructor : modelClass.getConstructors()) {
            Object[] parameterTypes = constructor.getParameterTypes();
            if (!Arrays.equals(signature, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    void onRequery(@NonNull ViewModel viewModel) {
        SavedStateHandleController.attachHandleIfNeeded(viewModel, this.mSavedStateRegistry, this.mLifecycle);
    }
}

