/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.compose;

import android.os.Bundle;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.BundleKt;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.compose.ComposeNavigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="composable")
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0000J\b\u0010\u0006\u001a\u00020\u0002H\u0016J0\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/navigation/compose/ComposeNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/compose/ComposeNavigator$Destination;", "backstack", "", "", "createDestination", "navigate", "Landroidx/navigation/NavDestination;", "destination", "args", "Landroid/os/Bundle;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "onRestoreState", "", "savedState", "onSaveState", "popBackStack", "", "Companion", "Destination", "navigation-compose_release"})
@StabilityInferred(parameters=0)
public final class ComposeNavigator
extends Navigator<Destination> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Integer> backstack;
    public static final int $stable = 8;
    @NotNull
    private static final String KEY_BACK_STACK_IDS = "androidx-nav-compose:navigator:backStackIds";

    public ComposeNavigator() {
        boolean bl = false;
        this.backstack = new ArrayList();
    }

    @Nullable
    public NavDestination navigate(@NotNull Destination destination, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter((Object)((Object)destination), (String)"destination");
        NavOptions navOptions2 = navOptions;
        if (Intrinsics.areEqual((Object)(navOptions2 == null ? null : Boolean.valueOf(navOptions2.shouldLaunchSingleTop())), (Object)true)) {
            Integer n = (Integer)CollectionsKt.lastOrNull(this.backstack);
            int n2 = destination.getId();
            if (n != null && n == n2) {
                return null;
            }
        }
        this.backstack.add(destination.getId());
        return destination;
    }

    @NotNull
    public Destination createDestination() {
        return new Destination(this, (Function3)ComposableLambdaKt.composableLambdaInstance((int)-985532489, (boolean)true, (Object)((Object)createDestination.1.INSTANCE)));
    }

    public boolean popBackStack() {
        return CollectionsKt.removeLastOrNull(this.backstack) != null;
    }

    @Nullable
    public Bundle onSaveState() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)KEY_BACK_STACK_IDS, (Object)CollectionsKt.toIntArray((Collection)this.backstack))};
        return BundleKt.bundleOf((Pair[])pairArray);
    }

    public void onRestoreState(@NotNull Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)savedState, (String)"savedState");
        int[] restoredBackStack = savedState.getIntArray(KEY_BACK_STACK_IDS);
        if (restoredBackStack != null) {
            this.backstack.clear();
            this.backstack.addAll(ArraysKt.asList((int[])restoredBackStack));
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bR'\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Landroidx/navigation/compose/ComposeNavigator$Destination;", "Landroidx/navigation/NavDestination;", "navigator", "Landroidx/navigation/compose/ComposeNavigator;", "content", "Lkotlin/Function1;", "Landroidx/navigation/NavBackStackEntry;", "", "Landroidx/compose/runtime/Composable;", "getContent$navigation_compose_release", "()Lkotlin/jvm/functions/Function3;", "Lkotlin/jvm/functions/Function3;", "navigation-compose_release"})
    @NavDestination.ClassType(value=Composable.class)
    @StabilityInferred(parameters=0)
    public static final class Destination
    extends NavDestination {
        @NotNull
        private final Function3<NavBackStackEntry, Composer<?>, Integer, Unit> content;
        public static final int $stable;

        public Destination(@NotNull ComposeNavigator navigator, @NotNull Function3<? super NavBackStackEntry, ? super Composer<?>, ? super Integer, Unit> content) {
            Intrinsics.checkNotNullParameter((Object)((Object)navigator), (String)"navigator");
            Intrinsics.checkNotNullParameter(content, (String)"content");
            super((Navigator)navigator);
            this.content = content;
        }

        @NotNull
        public final Function3<NavBackStackEntry, Composer<?>, Integer, Unit> getContent$navigation_compose_release() {
            return this.content;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"Landroidx/navigation/compose/ComposeNavigator$Companion;", "", "KEY_BACK_STACK_IDS", "", "navigation-compose_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

