/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.dynamicfeatures;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavInflater;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.dynamicfeatures.DynamicExtras;
import androidx.navigation.dynamicfeatures.DynamicInstallManager;
import androidx.navigation.dynamicfeatures.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="include-dynamic")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0002H\u0016J0\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicIncludeGraphNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/dynamicfeatures/DynamicIncludeGraphNavigator$DynamicIncludeNavGraph;", "context", "Landroid/content/Context;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "navInflater", "Landroidx/navigation/NavInflater;", "installManager", "Landroidx/navigation/dynamicfeatures/DynamicInstallManager;", "(Landroid/content/Context;Landroidx/navigation/NavigatorProvider;Landroidx/navigation/NavInflater;Landroidx/navigation/dynamicfeatures/DynamicInstallManager;)V", "createdDestinations", "", "packageName", "", "getPackageName", "()Ljava/lang/String;", "createDestination", "navigate", "Landroidx/navigation/NavDestination;", "destination", "args", "Landroid/os/Bundle;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "onRestoreState", "", "savedState", "onSaveState", "popBackStack", "", "replaceWithIncludedNav", "Landroidx/navigation/NavGraph;", "DynamicIncludeNavGraph", "navigation-dynamic-features-runtime_release"})
public final class DynamicIncludeGraphNavigator
extends Navigator<DynamicIncludeNavGraph> {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    private final String packageName;
    private final List<DynamicIncludeNavGraph> createdDestinations;
    private final Context context;
    private final NavigatorProvider navigatorProvider;
    private final NavInflater navInflater;
    private final DynamicInstallManager installManager;

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public DynamicIncludeNavGraph createDestination() {
        DynamicIncludeNavGraph dynamicIncludeNavGraph = new DynamicIncludeNavGraph((Navigator<? extends NavDestination>)((Navigator)this));
        boolean bl = false;
        boolean bl2 = false;
        DynamicIncludeNavGraph it = dynamicIncludeNavGraph;
        boolean bl3 = false;
        this.createdDestinations.add(it);
        return dynamicIncludeNavGraph;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public NavDestination navigate(@NotNull DynamicIncludeNavGraph destination, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        NavDestination navDestination;
        Intrinsics.checkParameterIsNotNull((Object)((Object)destination), (String)"destination");
        Navigator.Extras extras = navigatorExtras;
        if (!(extras instanceof DynamicExtras)) {
            extras = null;
        }
        DynamicExtras extras2 = (DynamicExtras)extras;
        String moduleName = destination.getModuleName();
        if (moduleName != null && this.installManager.needsInstall(moduleName)) {
            navDestination = this.installManager.performInstall(destination, args, extras2, moduleName);
        } else {
            void $this$get$iv;
            NavGraph includedNav = this.replaceWithIncludedNav(destination);
            NavigatorProvider navigatorProvider = this.navigatorProvider;
            String string = includedNav.getNavigatorName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"includedNav.navigatorName");
            String name$iv = string;
            boolean $i$f$get = false;
            Navigator navigator = $this$get$iv.getNavigator(name$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)navigator, (String)"getNavigator(name)");
            Navigator navigator2 = navigator;
            navDestination = navigator2.navigate((NavDestination)includedNav, args, navOptions, navigatorExtras);
        }
        return navDestination;
    }

    private final NavGraph replaceWithIncludedNav(DynamicIncludeNavGraph destination) {
        int graphId = this.context.getResources().getIdentifier(destination.getGraphResourceName(), "navigation", destination.getGraphPackage());
        if (graphId == 0) {
            throw (Throwable)new Resources.NotFoundException(destination.getGraphPackage() + ":navigation/" + destination.getGraphResourceName());
        }
        NavGraph navGraph = this.navInflater.inflate(graphId);
        Intrinsics.checkExpressionValueIsNotNull((Object)navGraph, (String)"navInflater.inflate(graphId)");
        NavGraph includedNav = navGraph;
        boolean bl = includedNav.getId() == 0 || includedNav.getId() == destination.getId();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The included <navigation>'s id " + includedNav.getDisplayName() + " is different from " + "the destination id " + destination.getDisplayName() + ". Either remove the " + "<navigation> id or make them match.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        includedNav.setId(destination.getId());
        NavGraph navGraph2 = destination.getParent();
        if (navGraph2 == null) {
            throw (Throwable)new IllegalStateException("The include-dynamic destination with id " + destination.getDisplayName() + ' ' + "does not have a parent. Make sure it is attached to a NavGraph.");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)navGraph2, (String)"destination.parent\n     \u2026 NavGraph.\"\n            )");
        NavGraph outerNav = navGraph2;
        outerNav.addDestination((NavDestination)includedNav);
        this.createdDestinations.remove((Object)destination);
        return includedNav;
    }

    public boolean popBackStack() {
        return true;
    }

    @Nullable
    public Bundle onSaveState() {
        return Bundle.EMPTY;
    }

    public void onRestoreState(@NotNull Bundle savedState) {
        Intrinsics.checkParameterIsNotNull((Object)savedState, (String)"savedState");
        super.onRestoreState(savedState);
        block0: while (true) {
            Collection collection = this.createdDestinations;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            Intrinsics.checkExpressionValueIsNotNull(new ArrayList(this.createdDestinations).iterator(), (String)"ArrayList(createdDestinations).iterator()");
            this.createdDestinations.clear();
            while (true) {
                Iterator iterator;
                if (!iterator.hasNext()) continue block0;
                DynamicIncludeNavGraph dynamicNavGraph = (DynamicIncludeNavGraph)((Object)iterator.next());
                String moduleName = dynamicNavGraph.getModuleName();
                if (moduleName != null && this.installManager.needsInstall(moduleName)) continue;
                DynamicIncludeNavGraph dynamicIncludeNavGraph = dynamicNavGraph;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dynamicIncludeNavGraph), (String)"dynamicNavGraph");
                this.replaceWithIncludedNav(dynamicIncludeNavGraph);
            }
            break;
        }
    }

    public DynamicIncludeGraphNavigator(@NotNull Context context, @NotNull NavigatorProvider navigatorProvider, @NotNull NavInflater navInflater, @NotNull DynamicInstallManager installManager) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)navigatorProvider, (String)"navigatorProvider");
        Intrinsics.checkParameterIsNotNull((Object)navInflater, (String)"navInflater");
        Intrinsics.checkParameterIsNotNull((Object)installManager, (String)"installManager");
        this.context = context;
        this.navigatorProvider = navigatorProvider;
        this.navInflater = navInflater;
        this.installManager = installManager;
        String string = this.context.getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.packageName");
        this.packageName = string;
        DynamicIncludeGraphNavigator dynamicIncludeGraphNavigator = this;
        boolean bl = false;
        dynamicIncludeGraphNavigator.createdDestinations = list = (List)new ArrayList();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\n\u00a8\u0006\u0019"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicIncludeGraphNavigator$DynamicIncludeNavGraph;", "Landroidx/navigation/NavDestination;", "navGraphNavigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "graphPackage", "", "getGraphPackage", "()Ljava/lang/String;", "setGraphPackage", "(Ljava/lang/String;)V", "graphResourceName", "getGraphResourceName", "setGraphResourceName", "moduleName", "getModuleName", "setModuleName", "getPackageOrDefault", "context", "Landroid/content/Context;", "getPackageOrDefault$navigation_dynamic_features_runtime_release", "onInflate", "", "attrs", "Landroid/util/AttributeSet;", "navigation-dynamic-features-runtime_release"})
    public static final class DynamicIncludeNavGraph
    extends NavDestination {
        @Nullable
        private String graphResourceName;
        @Nullable
        private String graphPackage;
        @Nullable
        private String moduleName;

        @Nullable
        public final String getGraphResourceName() {
            return this.graphResourceName;
        }

        public final void setGraphResourceName(@Nullable String string) {
            this.graphResourceName = string;
        }

        @Nullable
        public final String getGraphPackage() {
            return this.graphPackage;
        }

        public final void setGraphPackage(@Nullable String string) {
            this.graphPackage = string;
        }

        @Nullable
        public final String getModuleName() {
            return this.moduleName;
        }

        public final void setModuleName(@Nullable String string) {
            this.moduleName = string;
        }

        /*
         * WARNING - void declaration
         */
        public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
            String string;
            void $this$withStyledAttributes$iv;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
            super.onInflate(context, attrs);
            Context context2 = context;
            Intrinsics.checkExpressionValueIsNotNull((Object)R.styleable.DynamicIncludeGraphNavigator, (String)"R.styleable.DynamicIncludeGraphNavigator");
            int[] attrs$iv = R.styleable.DynamicIncludeGraphNavigator;
            int defStyleAttr$iv = 0;
            int defStyleRes$iv = 0;
            boolean $i$f$withStyledAttributes = false;
            TypedArray typedArray = $this$withStyledAttributes$iv.obtainStyledAttributes(attrs, attrs$iv, defStyleAttr$iv, defStyleRes$iv);
            boolean bl = false;
            boolean bl2 = false;
            TypedArray $this$withStyledAttributes = typedArray;
            boolean bl3 = false;
            this.moduleName = $this$withStyledAttributes.getString(R.styleable.DynamicIncludeGraphNavigator_moduleName);
            CharSequence charSequence = this.moduleName;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = !(charSequence == null || charSequence.length() == 0);
            bl4 = false;
            bl5 = false;
            if (!bl6) {
                boolean bl7 = false;
                String string2 = "`moduleName` must be set for <include-dynamic>";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            CharSequence charSequence2 = $this$withStyledAttributes.getString(R.styleable.DynamicIncludeGraphNavigator_graphPackage);
            DynamicIncludeNavGraph dynamicIncludeNavGraph = this;
            bl4 = false;
            bl5 = false;
            String it = charSequence2;
            boolean bl8 = false;
            if (it != null) {
                CharSequence charSequence3 = it;
                boolean bl9 = false;
                boolean bl10 = charSequence3.length() > 0;
                bl9 = false;
                boolean bl11 = false;
                if (!bl10) {
                    boolean bl12 = false;
                    String string3 = "`graphPackage` cannot be empty for <include-dynamic>. You can omit the `graphPackage` attribute entirely to use the " + "default of " + context.getPackageName() + '.' + this.moduleName + '.';
                    throw (Throwable)new IllegalArgumentException(string3.toString());
                }
            }
            dynamicIncludeNavGraph.graphPackage = string = this.getPackageOrDefault$navigation_dynamic_features_runtime_release(context, it);
            this.graphResourceName = $this$withStyledAttributes.getString(R.styleable.DynamicIncludeGraphNavigator_graphResName);
            charSequence2 = this.graphResourceName;
            bl4 = false;
            bl5 = false;
            boolean bl13 = !(charSequence2 == null || charSequence2.length() == 0);
            bl4 = false;
            bl5 = false;
            if (!bl13) {
                boolean bl14 = false;
                String string4 = "`graphResName` must be set for <include-dynamic>";
                throw (Throwable)new IllegalArgumentException(string4.toString());
            }
            typedArray.recycle();
        }

        @NotNull
        public final String getPackageOrDefault$navigation_dynamic_features_runtime_release(@NotNull Context context, @Nullable String graphPackage) {
            String string;
            block3: {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    string = graphPackage;
                    if (string == null) break block2;
                    String string2 = context.getPackageName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.packageName");
                    if ((string = StringsKt.replace$default((String)string, (String)"${applicationId}", (String)string2, (boolean)false, (int)4, null)) != null) break block3;
                }
                string = context.getPackageName() + '.' + this.moduleName;
            }
            return string;
        }

        public DynamicIncludeNavGraph(@NotNull Navigator<? extends NavDestination> navGraphNavigator) {
            Intrinsics.checkParameterIsNotNull(navGraphNavigator, (String)"navGraphNavigator");
            super(navGraphNavigator);
        }
    }
}

