/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.dynamicfeatures;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.navigation.NavDestination;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.dynamicfeatures.DynamicExtras;
import androidx.navigation.dynamicfeatures.DynamicGraphNavigator;
import androidx.navigation.dynamicfeatures.DynamicInstallMonitor;
import com.google.android.play.core.splitcompat.SplitCompat;
import com.google.android.play.core.splitinstall.SplitInstallException;
import com.google.android.play.core.splitinstall.SplitInstallHelper;
import com.google.android.play.core.splitinstall.SplitInstallManager;
import com.google.android.play.core.splitinstall.SplitInstallRequest;
import com.google.android.play.core.splitinstall.SplitInstallSessionState;
import com.google.android.play.core.splitinstall.SplitInstallStateUpdatedListener;
import com.google.android.play.core.tasks.OnFailureListener;
import com.google.android.play.core.tasks.OnSuccessListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J.\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicInstallManager;", "", "context", "Landroid/content/Context;", "splitInstallManager", "Lcom/google/android/play/core/splitinstall/SplitInstallManager;", "(Landroid/content/Context;Lcom/google/android/play/core/splitinstall/SplitInstallManager;)V", "needsInstall", "", "module", "", "performInstall", "Landroidx/navigation/NavDestination;", "destination", "args", "Landroid/os/Bundle;", "extras", "Landroidx/navigation/dynamicfeatures/DynamicExtras;", "moduleName", "requestInstall", "", "installMonitor", "Landroidx/navigation/dynamicfeatures/DynamicInstallMonitor;", "Companion", "SplitInstallListenerWrapper", "navigation-dynamic-features-runtime_release"})
public class DynamicInstallManager {
    private final Context context;
    private final SplitInstallManager splitInstallManager;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination performInstall(@NotNull NavDestination destination, @Nullable Bundle args, @Nullable DynamicExtras extras, @NotNull String moduleName) {
        void $this$get$iv;
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        DynamicExtras dynamicExtras = extras;
        if ((dynamicExtras != null ? dynamicExtras.getInstallMonitor() : null) != null) {
            this.requestInstall(moduleName, extras.getInstallMonitor());
            return null;
        }
        Bundle bundle = new Bundle();
        boolean bl = false;
        boolean bl2 = false;
        Bundle $this$apply = bundle;
        boolean bl3 = false;
        $this$apply.putInt("dfn:destinationId", destination.getId());
        $this$apply.putBundle("dfn:destinationArgs", args);
        Bundle progressArgs = bundle;
        DynamicGraphNavigator.DynamicNavGraph dynamicNavGraph = DynamicGraphNavigator.DynamicNavGraph.Companion.getOrThrow$navigation_dynamic_features_runtime_release(destination);
        NavigatorProvider navigatorProvider = dynamicNavGraph.getNavigatorProvider$navigation_dynamic_features_runtime_release();
        String string = dynamicNavGraph.getNavigatorName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dynamicNavGraph.navigatorName");
        String name$iv = string;
        boolean $i$f$get = false;
        Navigator navigator = $this$get$iv.getNavigator(name$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)navigator, (String)"getNavigator(name)");
        Navigator navigator2 = navigator;
        if (!(navigator2 instanceof DynamicGraphNavigator)) {
            throw (Throwable)new IllegalStateException("You must use a DynamicNavGraph to perform a module installation.");
        }
        return ((DynamicGraphNavigator)navigator2).navigateToProgressDestination$navigation_dynamic_features_runtime_release(dynamicNavGraph, progressArgs);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean needsInstall(@NotNull String module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return !this.splitInstallManager.getInstalledModules().contains(module);
    }

    private final void requestInstall(String module, DynamicInstallMonitor installMonitor) {
        boolean bl = !installMonitor.isUsed$navigation_dynamic_features_runtime_release();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "You must pass in a fresh DynamicInstallMonitor in DynamicExtras every time you call navigate().";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        LiveData<SplitInstallSessionState> liveData = installMonitor.getStatus();
        if (liveData == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.lifecycle.MutableLiveData<com.google.android.play.core.splitinstall.SplitInstallSessionState>");
        }
        MutableLiveData status = (MutableLiveData)liveData;
        installMonitor.setInstallRequired$navigation_dynamic_features_runtime_release(true);
        SplitInstallRequest splitInstallRequest = SplitInstallRequest.newBuilder().addModule(module).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)splitInstallRequest, (String)"SplitInstallRequest\n    \u2026ule)\n            .build()");
        SplitInstallRequest request = splitInstallRequest;
        this.splitInstallManager.startInstall(request).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Integer>(this, installMonitor, status, module){
            final /* synthetic */ DynamicInstallManager this$0;
            final /* synthetic */ DynamicInstallMonitor $installMonitor;
            final /* synthetic */ MutableLiveData $status;
            final /* synthetic */ String $module;

            public final void onSuccess(Integer sessionId) {
                Integer n = sessionId;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"sessionId");
                this.$installMonitor.setSessionId$navigation_dynamic_features_runtime_release(n);
                this.$installMonitor.setSplitInstallManager$navigation_dynamic_features_runtime_release(DynamicInstallManager.access$getSplitInstallManager$p(this.this$0));
                if (sessionId == 0) {
                    this.$status.setValue((Object)SplitInstallSessionState.create((int)sessionId, (int)5, (int)0, (long)0L, (long)0L, (List)CollectionsKt.listOf((Object)this.$module), (List)CollectionsKt.emptyList()));
                    DynamicInstallManager.Companion.terminateLiveData$navigation_dynamic_features_runtime_release((MutableLiveData<SplitInstallSessionState>)this.$status);
                } else {
                    SplitInstallListenerWrapper listener = new SplitInstallListenerWrapper(DynamicInstallManager.access$getContext$p(this.this$0), (MutableLiveData<SplitInstallSessionState>)this.$status, this.$installMonitor);
                    DynamicInstallManager.access$getSplitInstallManager$p(this.this$0).registerListener((SplitInstallStateUpdatedListener)listener);
                }
            }
            {
                this.this$0 = dynamicInstallManager;
                this.$installMonitor = dynamicInstallMonitor;
                this.$status = mutableLiveData;
                this.$module = string;
            }
        }).addOnFailureListener(new OnFailureListener(module, installMonitor, status){
            final /* synthetic */ String $module;
            final /* synthetic */ DynamicInstallMonitor $installMonitor;
            final /* synthetic */ MutableLiveData $status;

            public final void onFailure(Exception exception) {
                Log.i((String)"DynamicInstallManager", (String)("Error requesting install of " + this.$module + ": " + exception.getMessage()));
                this.$installMonitor.setException$navigation_dynamic_features_runtime_release(exception);
                this.$status.setValue((Object)SplitInstallSessionState.create((int)0, (int)6, (int)(exception instanceof SplitInstallException ? ((SplitInstallException)exception).getErrorCode() : -100), (long)0L, (long)0L, (List)CollectionsKt.listOf((Object)this.$module), (List)CollectionsKt.emptyList()));
                DynamicInstallManager.Companion.terminateLiveData$navigation_dynamic_features_runtime_release((MutableLiveData<SplitInstallSessionState>)this.$status);
            }
            {
                this.$module = string;
                this.$installMonitor = dynamicInstallMonitor;
                this.$status = mutableLiveData;
            }
        });
    }

    public DynamicInstallManager(@NotNull Context context, @NotNull SplitInstallManager splitInstallManager) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)splitInstallManager, (String)"splitInstallManager");
        this.context = context;
        this.splitInstallManager = splitInstallManager;
    }

    public static final /* synthetic */ SplitInstallManager access$getSplitInstallManager$p(DynamicInstallManager $this) {
        return $this.splitInstallManager;
    }

    public static final /* synthetic */ Context access$getContext$p(DynamicInstallManager $this) {
        return $this.context;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicInstallManager$SplitInstallListenerWrapper;", "Lcom/google/android/play/core/splitinstall/SplitInstallStateUpdatedListener;", "context", "Landroid/content/Context;", "status", "Landroidx/lifecycle/MutableLiveData;", "Lcom/google/android/play/core/splitinstall/SplitInstallSessionState;", "installMonitor", "Landroidx/navigation/dynamicfeatures/DynamicInstallMonitor;", "(Landroid/content/Context;Landroidx/lifecycle/MutableLiveData;Landroidx/navigation/dynamicfeatures/DynamicInstallMonitor;)V", "onStateUpdate", "", "splitInstallSessionState", "navigation-dynamic-features-runtime_release"})
    private static final class SplitInstallListenerWrapper
    implements SplitInstallStateUpdatedListener {
        private final Context context;
        private final MutableLiveData<SplitInstallSessionState> status;
        private final DynamicInstallMonitor installMonitor;

        public void onStateUpdate(@NotNull SplitInstallSessionState splitInstallSessionState) {
            Intrinsics.checkParameterIsNotNull((Object)splitInstallSessionState, (String)"splitInstallSessionState");
            if (splitInstallSessionState.sessionId() == this.installMonitor.getSessionId()) {
                if (splitInstallSessionState.status() == 5) {
                    SplitCompat.install((Context)this.context);
                    SplitInstallHelper.updateAppInfo((Context)this.context);
                }
                this.status.setValue((Object)splitInstallSessionState);
                if (splitInstallSessionState.hasTerminalStatus()) {
                    SplitInstallManager splitInstallManager = this.installMonitor.getSplitInstallManager$navigation_dynamic_features_runtime_release();
                    if (splitInstallManager == null) {
                        Intrinsics.throwNpe();
                    }
                    splitInstallManager.unregisterListener((SplitInstallStateUpdatedListener)this);
                    Companion.terminateLiveData$navigation_dynamic_features_runtime_release(this.status);
                }
            }
        }

        public SplitInstallListenerWrapper(@NotNull Context context, @NotNull MutableLiveData<SplitInstallSessionState> status, @NotNull DynamicInstallMonitor installMonitor) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)installMonitor, (String)"installMonitor");
            this.context = context;
            this.status = status;
            this.installMonitor = installMonitor;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicInstallManager$Companion;", "", "()V", "terminateLiveData", "", "status", "Landroidx/lifecycle/MutableLiveData;", "Lcom/google/android/play/core/splitinstall/SplitInstallSessionState;", "terminateLiveData$navigation_dynamic_features_runtime_release", "navigation-dynamic-features-runtime_release"})
    public static final class Companion {
        public final void terminateLiveData$navigation_dynamic_features_runtime_release(@NotNull MutableLiveData<SplitInstallSessionState> status) {
            Intrinsics.checkParameterIsNotNull(status, (String)"status");
            boolean bl = !status.hasActiveObservers();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "This DynamicInstallMonitor will not emit any more status updates. You should remove all Observers after null has been emitted.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

