/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.dynamicfeatures;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.dynamicfeatures.DynamicExtras;
import androidx.navigation.dynamicfeatures.DynamicGraphNavigator;
import androidx.navigation.dynamicfeatures.DynamicInstallMonitor;
import com.google.android.play.core.splitcompat.SplitCompat;
import com.google.android.play.core.splitinstall.SplitInstallException;
import com.google.android.play.core.splitinstall.SplitInstallHelper;
import com.google.android.play.core.splitinstall.SplitInstallManager;
import com.google.android.play.core.splitinstall.SplitInstallRequest;
import com.google.android.play.core.splitinstall.SplitInstallSessionState;
import com.google.android.play.core.splitinstall.SplitInstallStateUpdatedListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicInstallManager;", "", "context", "Landroid/content/Context;", "splitInstallManager", "Lcom/google/android/play/core/splitinstall/SplitInstallManager;", "(Landroid/content/Context;Lcom/google/android/play/core/splitinstall/SplitInstallManager;)V", "needsInstall", "", "module", "", "performInstall", "Landroidx/navigation/NavDestination;", "backStackEntry", "Landroidx/navigation/NavBackStackEntry;", "extras", "Landroidx/navigation/dynamicfeatures/DynamicExtras;", "moduleName", "requestInstall", "", "installMonitor", "Landroidx/navigation/dynamicfeatures/DynamicInstallMonitor;", "Companion", "SplitInstallListenerWrapper", "navigation-dynamic-features-runtime_release"})
@SourceDebugExtension(value={"SMAP\nDynamicInstallManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicInstallManager.kt\nandroidx/navigation/dynamicfeatures/DynamicInstallManager\n+ 2 NavigatorProvider.kt\nandroidx/navigation/NavigatorProviderKt\n*L\n1#1,188:1\n150#2:189\n*S KotlinDebug\n*F\n+ 1 DynamicInstallManager.kt\nandroidx/navigation/dynamicfeatures/DynamicInstallManager\n*L\n78#1:189\n*E\n"})
public class DynamicInstallManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final SplitInstallManager splitInstallManager;

    public DynamicInstallManager(@NotNull Context context, @NotNull SplitInstallManager splitInstallManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)splitInstallManager, (String)"splitInstallManager");
        this.context = context;
        this.splitInstallManager = splitInstallManager;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination performInstall(@NotNull NavBackStackEntry backStackEntry, @Nullable DynamicExtras extras, @NotNull String moduleName) {
        void $this$get$iv;
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        DynamicExtras dynamicExtras = extras;
        if ((dynamicExtras != null ? dynamicExtras.getInstallMonitor() : null) != null) {
            this.requestInstall(moduleName, extras.getInstallMonitor());
            return null;
        }
        Bundle $this$performInstall_u24lambda_u240 = bundle = new Bundle();
        boolean $i$a$-apply-DynamicInstallManager$performInstall$progressArgs$22 = false;
        $this$performInstall_u24lambda_u240.putInt("dfn:destinationId", backStackEntry.getDestination().getId());
        $this$performInstall_u24lambda_u240.putBundle("dfn:destinationArgs", backStackEntry.getArguments());
        Bundle progressArgs = bundle;
        DynamicGraphNavigator.DynamicNavGraph dynamicNavGraph = DynamicGraphNavigator.DynamicNavGraph.Companion.getOrThrow$navigation_dynamic_features_runtime_release(backStackEntry.getDestination());
        NavigatorProvider $i$a$-apply-DynamicInstallManager$performInstall$progressArgs$22 = dynamicNavGraph.getNavigatorProvider$navigation_dynamic_features_runtime_release();
        String name$iv = dynamicNavGraph.getNavigatorName();
        boolean $i$f$get = false;
        Navigator navigator = $this$get$iv.getNavigator(name$iv);
        if (navigator instanceof DynamicGraphNavigator) {
            ((DynamicGraphNavigator)navigator).navigateToProgressDestination$navigation_dynamic_features_runtime_release(dynamicNavGraph, progressArgs);
            return null;
        }
        throw new IllegalStateException("You must use a DynamicNavGraph to perform a module installation.");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean needsInstall(@NotNull String module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return !this.splitInstallManager.getInstalledModules().contains(module);
    }

    private final void requestInstall(String module, DynamicInstallMonitor installMonitor) {
        if (!(!installMonitor.isUsed$navigation_dynamic_features_runtime_release())) {
            boolean $i$a$-check-DynamicInstallManager$requestInstall$22 = false;
            String $i$a$-check-DynamicInstallManager$requestInstall$22 = "You must pass in a fresh DynamicInstallMonitor in DynamicExtras every time you call navigate().";
            throw new IllegalStateException($i$a$-check-DynamicInstallManager$requestInstall$22.toString());
        }
        LiveData<SplitInstallSessionState> liveData = installMonitor.getStatus();
        Intrinsics.checkNotNull(liveData, (String)"null cannot be cast to non-null type androidx.lifecycle.MutableLiveData<com.google.android.play.core.splitinstall.SplitInstallSessionState>");
        MutableLiveData status = (MutableLiveData)liveData;
        installMonitor.setInstallRequired$navigation_dynamic_features_runtime_release(true);
        SplitInstallRequest splitInstallRequest = SplitInstallRequest.newBuilder().addModule(module).build();
        Intrinsics.checkNotNullExpressionValue((Object)splitInstallRequest, (String)"newBuilder()\n           \u2026ule)\n            .build()");
        SplitInstallRequest request = splitInstallRequest;
        this.splitInstallManager.startInstall(request).addOnSuccessListener(arg_0 -> DynamicInstallManager.requestInstall$lambda$2((Function1)new Function1<Integer, Unit>(installMonitor, this, (MutableLiveData<SplitInstallSessionState>)status, module){
            final /* synthetic */ DynamicInstallMonitor $installMonitor;
            final /* synthetic */ DynamicInstallManager this$0;
            final /* synthetic */ MutableLiveData<SplitInstallSessionState> $status;
            final /* synthetic */ String $module;
            {
                this.$installMonitor = $installMonitor;
                this.this$0 = $receiver;
                this.$status = $status;
                this.$module = $module;
                super(1);
            }

            public final void invoke(Integer sessionId) {
                Intrinsics.checkNotNullExpressionValue((Object)sessionId, (String)"sessionId");
                this.$installMonitor.setSessionId$navigation_dynamic_features_runtime_release(sessionId);
                this.$installMonitor.setSplitInstallManager(DynamicInstallManager.access$getSplitInstallManager$p(this.this$0));
                if (sessionId == 0) {
                    this.$status.setValue((Object)SplitInstallSessionState.create((int)sessionId, (int)5, (int)0, (long)0L, (long)0L, (List)CollectionsKt.listOf((Object)this.$module), (List)CollectionsKt.emptyList()));
                    DynamicInstallManager.Companion.terminateLiveData$navigation_dynamic_features_runtime_release(this.$status);
                } else {
                    SplitInstallListenerWrapper listener = new SplitInstallListenerWrapper(DynamicInstallManager.access$getContext$p(this.this$0), this.$status, this.$installMonitor);
                    DynamicInstallManager.access$getSplitInstallManager$p(this.this$0).registerListener((SplitInstallStateUpdatedListener)listener);
                }
            }
        }, arg_0)).addOnFailureListener(arg_0 -> DynamicInstallManager.requestInstall$lambda$3(module, installMonitor, status, arg_0));
    }

    private static final void requestInstall$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void requestInstall$lambda$3(String $module, DynamicInstallMonitor $installMonitor, MutableLiveData $status, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)$installMonitor, (String)"$installMonitor");
        Intrinsics.checkNotNullParameter((Object)$status, (String)"$status");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Log.i((String)"DynamicInstallManager", (String)("Error requesting install of " + $module + ": " + exception.getMessage()));
        $installMonitor.setException$navigation_dynamic_features_runtime_release(exception);
        $status.setValue((Object)SplitInstallSessionState.create((int)0, (int)6, (int)(exception instanceof SplitInstallException ? ((SplitInstallException)exception).getErrorCode() : -100), (long)0L, (long)0L, (List)CollectionsKt.listOf((Object)$module), (List)CollectionsKt.emptyList()));
        Companion.terminateLiveData$navigation_dynamic_features_runtime_release((MutableLiveData<SplitInstallSessionState>)$status);
    }

    public static final /* synthetic */ SplitInstallManager access$getSplitInstallManager$p(DynamicInstallManager $this) {
        return $this.splitInstallManager;
    }

    public static final /* synthetic */ Context access$getContext$p(DynamicInstallManager $this) {
        return $this.context;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicInstallManager$Companion;", "", "()V", "terminateLiveData", "", "status", "Landroidx/lifecycle/MutableLiveData;", "Lcom/google/android/play/core/splitinstall/SplitInstallSessionState;", "terminateLiveData$navigation_dynamic_features_runtime_release", "navigation-dynamic-features-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void terminateLiveData$navigation_dynamic_features_runtime_release(@NotNull MutableLiveData<SplitInstallSessionState> status) {
            Intrinsics.checkNotNullParameter(status, (String)"status");
            if (!(!status.hasActiveObservers())) {
                boolean bl = false;
                String string = "This DynamicInstallMonitor will not emit any more status updates. You should remove all Observers after null has been emitted.";
                throw new IllegalStateException(string.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/navigation/dynamicfeatures/DynamicInstallManager$SplitInstallListenerWrapper;", "Lcom/google/android/play/core/splitinstall/SplitInstallStateUpdatedListener;", "context", "Landroid/content/Context;", "status", "Landroidx/lifecycle/MutableLiveData;", "Lcom/google/android/play/core/splitinstall/SplitInstallSessionState;", "installMonitor", "Landroidx/navigation/dynamicfeatures/DynamicInstallMonitor;", "(Landroid/content/Context;Landroidx/lifecycle/MutableLiveData;Landroidx/navigation/dynamicfeatures/DynamicInstallMonitor;)V", "onStateUpdate", "", "splitInstallSessionState", "navigation-dynamic-features-runtime_release"})
    private static final class SplitInstallListenerWrapper
    implements SplitInstallStateUpdatedListener {
        @NotNull
        private final Context context;
        @NotNull
        private final MutableLiveData<SplitInstallSessionState> status;
        @NotNull
        private final DynamicInstallMonitor installMonitor;

        public SplitInstallListenerWrapper(@NotNull Context context, @NotNull MutableLiveData<SplitInstallSessionState> status, @NotNull DynamicInstallMonitor installMonitor) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)installMonitor, (String)"installMonitor");
            this.context = context;
            this.status = status;
            this.installMonitor = installMonitor;
        }

        public void onStateUpdate(@NotNull SplitInstallSessionState splitInstallSessionState) {
            Intrinsics.checkNotNullParameter((Object)splitInstallSessionState, (String)"splitInstallSessionState");
            if (splitInstallSessionState.sessionId() == this.installMonitor.getSessionId()) {
                if (splitInstallSessionState.status() == 5) {
                    SplitCompat.install((Context)this.context);
                    SplitInstallHelper.updateAppInfo((Context)this.context);
                }
                this.status.setValue((Object)splitInstallSessionState);
                if (splitInstallSessionState.hasTerminalStatus()) {
                    SplitInstallManager splitInstallManager = this.installMonitor.getSplitInstallManager();
                    Intrinsics.checkNotNull((Object)splitInstallManager);
                    splitInstallManager.unregisterListener((SplitInstallStateUpdatedListener)this);
                    Companion.terminateLiveData$navigation_dynamic_features_runtime_release(this.status);
                }
            }
        }
    }
}

