/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentOnAttachListener;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.NavigatorState;
import androidx.navigation.fragment.DialogFragmentNavigator;
import androidx.navigation.fragment.R;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="dialog")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\"#B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0002H\u0016J0\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/navigation/fragment/DialogFragmentNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/fragment/DialogFragmentNavigator$Destination;", "context", "Landroid/content/Context;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "(Landroid/content/Context;Landroidx/fragment/app/FragmentManager;)V", "dialogCount", "", "observer", "Landroidx/lifecycle/LifecycleEventObserver;", "restoredTagsAwaitingAttach", "", "", "createDestination", "navigate", "Landroidx/navigation/NavDestination;", "destination", "args", "Landroid/os/Bundle;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "onAttach", "", "state", "Landroidx/navigation/NavigatorState;", "onRestoreState", "savedState", "onSaveState", "popBackStack", "", "Companion", "Destination", "navigation-fragment_release"})
public final class DialogFragmentNavigator
extends Navigator<Destination> {
    private int dialogCount;
    private final Set<String> restoredTagsAwaitingAttach;
    private final LifecycleEventObserver observer;
    private final Context context;
    private final FragmentManager fragmentManager;
    @Deprecated
    private static final String TAG = "DialogFragmentNavigator";
    @Deprecated
    private static final String KEY_DIALOG_COUNT = "androidx-nav-dialogfragment:navigator:count";
    @Deprecated
    private static final String DIALOG_TAG = "androidx-nav-fragment:navigator:dialog:";
    @NotNull
    private static final Companion Companion = new Companion(null);

    public boolean popBackStack() {
        if (this.dialogCount == 0) {
            return false;
        }
        if (this.fragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring popBackStack() call: FragmentManager has already saved its state");
            return false;
        }
        DialogFragmentNavigator dialogFragmentNavigator = this;
        dialogFragmentNavigator.dialogCount += -1;
        Fragment existingFragment = this.fragmentManager.findFragmentByTag(DIALOG_TAG + dialogFragmentNavigator.dialogCount);
        if (existingFragment != null) {
            existingFragment.getLifecycle().removeObserver((LifecycleObserver)this.observer);
            ((DialogFragment)existingFragment).dismiss();
        }
        return true;
    }

    @NotNull
    public Destination createDestination() {
        return new Destination((Navigator<? extends Destination>)((Navigator)this));
    }

    @Nullable
    public NavDestination navigate(@NotNull Destination destination, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter((Object)((Object)destination), (String)"destination");
        if (this.fragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring navigate() call: FragmentManager has already saved its state");
            return null;
        }
        String className = destination.getClassName();
        if (className.charAt(0) == '.') {
            className = this.context.getPackageName() + className;
        }
        Fragment fragment = this.fragmentManager.getFragmentFactory().instantiate(this.context.getClassLoader(), className);
        Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentManager.fragment\u2026ader, className\n        )");
        Fragment frag = fragment;
        boolean bl = DialogFragment.class.isAssignableFrom(frag.getClass());
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "Dialog destination " + destination.getClassName() + " is not an instance of DialogFragment";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Fragment fragment2 = frag;
        if (fragment2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.DialogFragment");
        }
        DialogFragment dialogFragment = (DialogFragment)fragment2;
        dialogFragment.setArguments(args);
        dialogFragment.getLifecycle().addObserver((LifecycleObserver)this.observer);
        n = this.dialogCount;
        this.dialogCount = n + 1;
        dialogFragment.show(this.fragmentManager, DIALOG_TAG + n);
        return destination;
    }

    @Nullable
    public Bundle onSaveState() {
        if (this.dialogCount == 0) {
            return null;
        }
        Bundle b = new Bundle();
        b.putInt(KEY_DIALOG_COUNT, this.dialogCount);
        return b;
    }

    /*
     * WARNING - void declaration
     */
    public void onRestoreState(@NotNull Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)savedState, (String)"savedState");
        this.dialogCount = savedState.getInt(KEY_DIALOG_COUNT, 0);
        int n = 0;
        int n2 = this.dialogCount;
        while (n < n2) {
            void index;
            DialogFragment fragment = (DialogFragment)this.fragmentManager.findFragmentByTag(DIALOG_TAG + (int)index);
            DialogFragment dialogFragment = fragment;
            if (dialogFragment != null && (dialogFragment = dialogFragment.getLifecycle()) != null) {
                dialogFragment.addObserver((LifecycleObserver)this.observer);
            } else {
                this.restoredTagsAwaitingAttach.add(DIALOG_TAG + (int)index);
            }
            ++index;
        }
    }

    public void onAttach(@NotNull NavigatorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onAttach(state);
        this.fragmentManager.addFragmentOnAttachListener(new FragmentOnAttachListener(this){
            final /* synthetic */ DialogFragmentNavigator this$0;

            public final void onAttachFragment(@NotNull FragmentManager $noName_0, @NotNull Fragment childFragment) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)childFragment, (String)"childFragment");
                boolean needToAddObserver = DialogFragmentNavigator.access$getRestoredTagsAwaitingAttach$p(this.this$0).remove(childFragment.getTag());
                if (needToAddObserver) {
                    childFragment.getLifecycle().addObserver((LifecycleObserver)DialogFragmentNavigator.access$getObserver$p(this.this$0));
                }
            }
            {
                this.this$0 = dialogFragmentNavigator;
            }
        });
    }

    public DialogFragmentNavigator(@NotNull Context context, @NotNull FragmentManager fragmentManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        this.context = context;
        this.fragmentManager = fragmentManager;
        boolean bl = false;
        this.restoredTagsAwaitingAttach = new LinkedHashSet();
        this.observer = observer.1.INSTANCE;
    }

    public static final /* synthetic */ Set access$getRestoredTagsAwaitingAttach$p(DialogFragmentNavigator $this) {
        return $this.restoredTagsAwaitingAttach;
    }

    public static final /* synthetic */ LifecycleEventObserver access$getObserver$p(DialogFragmentNavigator $this) {
        return $this.observer;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Landroidx/navigation/fragment/DialogFragmentNavigator$Destination;", "Landroidx/navigation/NavDestination;", "Landroidx/navigation/FloatingWindow;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "(Landroidx/navigation/NavigatorProvider;)V", "fragmentNavigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "_className", "", "className", "getClassName", "()Ljava/lang/String;", "onInflate", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "setClassName", "navigation-fragment_release"})
    @NavDestination.ClassType(value=DialogFragment.class)
    public static class Destination
    extends NavDestination
    implements FloatingWindow {
        private String _className;

        @NotNull
        public final String getClassName() {
            String string = this._className;
            boolean bl = false;
            boolean bl2 = false;
            if (string == null) {
                boolean bl3 = false;
                String string2 = "DialogFragment class was not set";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String string3 = this._className;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return string3;
        }

        @CallSuper
        public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
            Destination destination;
            String className;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
            super.onInflate(context, attrs);
            TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.DialogFragmentNavigator);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.resources.obtain\u2026ntNavigator\n            )");
            TypedArray $this$use$iv = typedArray;
            boolean $i$f$use = false;
            TypedArray array = $this$use$iv;
            boolean bl = false;
            String string = className = array.getString(R.styleable.DialogFragmentNavigator_android_name);
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                boolean bl3 = false;
                String it = string2;
                boolean bl4 = false;
                destination = this.setClassName(it);
            } else {
                destination = null;
            }
            Destination destination2 = destination;
            boolean bl5 = false;
            boolean bl6 = false;
            Destination it$iv = destination2;
            boolean bl7 = false;
            $this$use$iv.recycle();
        }

        @NotNull
        public final Destination setClassName(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this._className = className;
            return this;
        }

        public Destination(@NotNull Navigator<? extends Destination> fragmentNavigator) {
            Intrinsics.checkNotNullParameter(fragmentNavigator, (String)"fragmentNavigator");
            super(fragmentNavigator);
        }

        public Destination(@NotNull NavigatorProvider navigatorProvider) {
            Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
            this((Navigator<? extends Destination>)navigatorProvider.getNavigator(DialogFragmentNavigator.class));
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/fragment/DialogFragmentNavigator$Companion;", "", "()V", "DIALOG_TAG", "", "KEY_DIALOG_COUNT", "TAG", "navigation-fragment_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

