/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.core.os.BundleKt;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.fragment.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="fragment")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003#$%B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u0002H\u0016J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0017J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J*\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\"H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Landroidx/navigation/fragment/FragmentNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/fragment/FragmentNavigator$Destination;", "context", "Landroid/content/Context;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "containerId", "", "(Landroid/content/Context;Landroidx/fragment/app/FragmentManager;I)V", "savedIds", "", "", "createDestination", "instantiateFragment", "Landroidx/fragment/app/Fragment;", "className", "args", "Landroid/os/Bundle;", "navigate", "", "entry", "Landroidx/navigation/NavBackStackEntry;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "entries", "", "onRestoreState", "savedState", "onSaveState", "popBackStack", "popUpTo", "", "Companion", "Destination", "Extras", "navigation-fragment_release"})
public class FragmentNavigator
extends Navigator<Destination> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final FragmentManager fragmentManager;
    private final int containerId;
    @NotNull
    private final Set<String> savedIds;
    @java.lang.Deprecated
    @NotNull
    private static final String TAG = "FragmentNavigator";
    @java.lang.Deprecated
    @NotNull
    private static final String KEY_SAVED_IDS = "androidx-nav-fragment:navigator:savedIds";

    public FragmentNavigator(@NotNull Context context, @NotNull FragmentManager fragmentManager, int containerId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        this.context = context;
        this.fragmentManager = fragmentManager;
        this.containerId = containerId;
        boolean bl = false;
        this.savedIds = new LinkedHashSet();
    }

    public void popBackStack(@NotNull NavBackStackEntry popUpTo, boolean savedState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo, (String)"popUpTo");
        if (this.fragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring popBackStack() call: FragmentManager has already saved its state");
            return;
        }
        if (savedState) {
            List beforePopList = (List)this.getState().getBackStack().getValue();
            NavBackStackEntry initialEntry = (NavBackStackEntry)CollectionsKt.first((List)beforePopList);
            List poppedList = beforePopList.subList(beforePopList.indexOf(popUpTo), beforePopList.size());
            for (NavBackStackEntry entry : CollectionsKt.reversed((Iterable)poppedList)) {
                if (Intrinsics.areEqual((Object)entry, (Object)initialEntry)) {
                    Log.i((String)TAG, (String)Intrinsics.stringPlus((String)"FragmentManager cannot save the state of the initial destination ", (Object)entry));
                    continue;
                }
                this.fragmentManager.saveBackStack(entry.getId());
                FragmentNavigator fragmentNavigator = this;
                Collection collection = fragmentNavigator.savedIds;
                String string = entry.getId();
                boolean bl = false;
                collection.add(string);
            }
        } else {
            this.fragmentManager.popBackStack(popUpTo.getId(), 1);
        }
        this.getState().pop(popUpTo, savedState);
    }

    @NotNull
    public Destination createDestination() {
        return new Destination((Navigator<? extends Destination>)((Navigator)this));
    }

    @Deprecated(message="Set a custom {@link androidx.fragment.app.FragmentFactory} via\n      {@link FragmentManager#setFragmentFactory(FragmentFactory)} to control\n      instantiation of Fragments.")
    @NotNull
    public Fragment instantiateFragment(@NotNull Context context, @NotNull FragmentManager fragmentManager, @NotNull String className, @Nullable Bundle args) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Fragment fragment = fragmentManager.getFragmentFactory().instantiate(context.getClassLoader(), className);
        Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentManager.fragmentFactory.instantiate(context.classLoader, className)");
        return fragment;
    }

    public void navigate(@NotNull List<NavBackStackEntry> entries, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        if (this.fragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring navigate() call: FragmentManager has already saved its state");
            return;
        }
        for (NavBackStackEntry entry : entries) {
            this.navigate(entry, navOptions, navigatorExtras);
        }
    }

    private final void navigate(NavBackStackEntry entry, NavOptions navOptions, Navigator.Extras navigatorExtras) {
        boolean isAdded;
        boolean bl;
        int n;
        int popExitAnim;
        int n2;
        int n3;
        int n4;
        boolean restoreState;
        List backStack = (List)this.getState().getBackStack().getValue();
        boolean initialNavigation = backStack.isEmpty();
        boolean bl2 = restoreState = navOptions != null && !initialNavigation && navOptions.shouldRestoreState() && this.savedIds.remove(entry.getId());
        if (restoreState) {
            this.fragmentManager.restoreBackStack(entry.getId());
            this.getState().add(entry);
            return;
        }
        Destination destination = (Destination)entry.getDestination();
        Bundle args = entry.getArguments();
        String className = destination.getClassName();
        if (className.charAt(0) == '.') {
            className = Intrinsics.stringPlus((String)this.context.getPackageName(), (Object)className);
        }
        Fragment fragment = this.fragmentManager.getFragmentFactory().instantiate(this.context.getClassLoader(), className);
        Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentManager.fragmentFactory.instantiate(context.classLoader, className)");
        Fragment frag = fragment;
        frag.setArguments(args);
        FragmentTransaction fragmentTransaction = this.fragmentManager.beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"fragmentManager.beginTransaction()");
        FragmentTransaction ft = fragmentTransaction;
        NavOptions navOptions2 = navOptions;
        int enterAnim = navOptions2 == null ? -1 : (n4 = navOptions2.getEnterAnim());
        NavOptions navOptions3 = navOptions;
        int exitAnim = navOptions3 == null ? -1 : (n3 = navOptions3.getExitAnim());
        NavOptions navOptions4 = navOptions;
        int popEnterAnim = navOptions4 == null ? -1 : (n2 = navOptions4.getPopEnterAnim());
        NavOptions navOptions5 = navOptions;
        int n5 = popExitAnim = navOptions5 == null ? -1 : (n = navOptions5.getPopExitAnim());
        if (enterAnim != -1 || exitAnim != -1 || popEnterAnim != -1 || popExitAnim != -1) {
            enterAnim = enterAnim != -1 ? enterAnim : 0;
            exitAnim = exitAnim != -1 ? exitAnim : 0;
            popEnterAnim = popEnterAnim != -1 ? popEnterAnim : 0;
            popExitAnim = popExitAnim != -1 ? popExitAnim : 0;
            ft.setCustomAnimations(enterAnim, exitAnim, popEnterAnim, popExitAnim);
        }
        ft.replace(this.containerId, frag);
        ft.setPrimaryNavigationFragment(frag);
        int destId = destination.getId();
        boolean isSingleTopReplacement = navOptions != null && !initialNavigation && navOptions.shouldLaunchSingleTop() && ((NavBackStackEntry)CollectionsKt.last((List)backStack)).getDestination().getId() == destId;
        if (initialNavigation) {
            bl = true;
        } else if (isSingleTopReplacement) {
            if (backStack.size() > 1) {
                this.fragmentManager.popBackStack(entry.getId(), 1);
                ft.addToBackStack(entry.getId());
            }
            bl = false;
        } else {
            ft.addToBackStack(entry.getId());
            bl = isAdded = true;
        }
        if (navigatorExtras instanceof Extras) {
            Object object = ((Extras)navigatorExtras).getSharedElements();
            boolean bl3 = false;
            Iterator<Map.Entry<View, String>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl4 = false;
                View key = (View)object2.getKey();
                Object object3 = object;
                boolean bl5 = false;
                String value = (String)object3.getValue();
                ft.addSharedElement(key, value);
            }
        }
        ft.setReorderingAllowed(true);
        ft.commit();
        if (isAdded) {
            this.getState().add(entry);
        }
    }

    @Nullable
    public Bundle onSaveState() {
        if (this.savedIds.isEmpty()) {
            return null;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)KEY_SAVED_IDS, new ArrayList(this.savedIds))};
        return BundleKt.bundleOf((Pair[])pairArray);
    }

    public void onRestoreState(@NotNull Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)savedState, (String)"savedState");
        ArrayList savedIds = savedState.getStringArrayList(KEY_SAVED_IDS);
        if (savedIds != null) {
            this.savedIds.clear();
            FragmentNavigator fragmentNavigator = this;
            Collection collection = fragmentNavigator.savedIds;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)savedIds);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\tJ\b\u0010\u0014\u001a\u00020\tH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Landroidx/navigation/fragment/FragmentNavigator$Destination;", "Landroidx/navigation/NavDestination;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "(Landroidx/navigation/NavigatorProvider;)V", "fragmentNavigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "_className", "", "className", "getClassName", "()Ljava/lang/String;", "onInflate", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "setClassName", "toString", "navigation-fragment_release"})
    @NavDestination.ClassType(value=Fragment.class)
    public static class Destination
    extends NavDestination {
        @Nullable
        private String _className;

        public Destination(@NotNull Navigator<? extends Destination> fragmentNavigator) {
            Intrinsics.checkNotNullParameter(fragmentNavigator, (String)"fragmentNavigator");
            super(fragmentNavigator);
        }

        public Destination(@NotNull NavigatorProvider navigatorProvider) {
            Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
            this((Navigator<? extends Destination>)navigatorProvider.getNavigator(FragmentNavigator.class));
        }

        /*
         * WARNING - void declaration
         */
        @CallSuper
        public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
            void $this$use$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
            super.onInflate(context, attrs);
            TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.FragmentNavigator);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.resources.obtainAttributes(attrs, R.styleable.FragmentNavigator)");
            boolean $i$f$use = false;
            void array = $this$use$iv;
            boolean bl = false;
            String className = array.getString(R.styleable.FragmentNavigator_android_name);
            if (className != null) {
                this.setClassName(className);
            }
            Unit unit = Unit.INSTANCE;
            boolean bl2 = false;
            boolean bl3 = false;
            Unit it$iv = unit;
            boolean bl4 = false;
            $this$use$iv.recycle();
        }

        @NotNull
        public final Destination setClassName(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this._className = className;
            return this;
        }

        @NotNull
        public final String getClassName() {
            String string = this._className;
            boolean bl = false;
            boolean bl2 = false;
            if (string == null) {
                boolean bl3 = false;
                String string2 = "Fragment class was not set";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            string = this._className;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return string;
        }

        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" class=");
            if (this._className == null) {
                sb.append("null");
            } else {
                sb.append(this._className);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\fB\u001b\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Landroidx/navigation/fragment/FragmentNavigator$Extras;", "Landroidx/navigation/Navigator$Extras;", "sharedElements", "", "Landroid/view/View;", "", "(Ljava/util/Map;)V", "_sharedElements", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "getSharedElements", "()Ljava/util/Map;", "Builder", "navigation-fragment_release"})
    public static final class Extras
    implements Navigator.Extras {
        @NotNull
        private final LinkedHashMap<View, String> _sharedElements;

        public Extras(@NotNull Map<View, String> sharedElements) {
            Intrinsics.checkNotNullParameter(sharedElements, (String)"sharedElements");
            this._sharedElements = new LinkedHashMap();
            this._sharedElements.putAll(sharedElements);
        }

        @NotNull
        public final Map<View, String> getSharedElements() {
            return MapsKt.toMap((Map)this._sharedElements);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0006J\u001a\u0010\u000b\u001a\u00020\u00002\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\rJ\u0006\u0010\u000e\u001a\u00020\u000fR*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/navigation/fragment/FragmentNavigator$Extras$Builder;", "", "()V", "_sharedElements", "Ljava/util/LinkedHashMap;", "Landroid/view/View;", "", "Lkotlin/collections/LinkedHashMap;", "addSharedElement", "sharedElement", "name", "addSharedElements", "sharedElements", "", "build", "Landroidx/navigation/fragment/FragmentNavigator$Extras;", "navigation-fragment_release"})
        public static final class Builder {
            @NotNull
            private final LinkedHashMap<View, String> _sharedElements = new LinkedHashMap();

            @NotNull
            public final Builder addSharedElements(@NotNull Map<View, String> sharedElements) {
                Intrinsics.checkNotNullParameter(sharedElements, (String)"sharedElements");
                Object object = sharedElements;
                boolean bl = false;
                Iterator<Map.Entry<View, String>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object2 = object = iterator.next();
                    boolean bl2 = false;
                    View view = (View)object2.getKey();
                    Object object3 = object;
                    boolean bl3 = false;
                    String name = (String)object3.getValue();
                    this.addSharedElement(view, name);
                }
                return this;
            }

            @NotNull
            public final Builder addSharedElement(@NotNull View sharedElement, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)sharedElement, (String)"sharedElement");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Map map = this._sharedElements;
                boolean bl = false;
                map.put(sharedElement, name);
                return this;
            }

            @NotNull
            public final Extras build() {
                return new Extras((Map<View, String>)this._sharedElements);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/navigation/fragment/FragmentNavigator$Companion;", "", "()V", "KEY_SAVED_IDS", "", "TAG", "navigation-fragment_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

