/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.runtime.lint;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Landroidx/navigation/runtime/lint/DeepLinkInActivityDestinationDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "navigation-runtime-lint"})
public final class DeepLinkInActivityDestinationDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue DeepLinkInActivityDestination;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.NAVIGATION;
    }

    @Nullable
    public Collection<String> getApplicableElements() {
        return Collections.singleton("deepLink");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Node node = element.getParentNode();
        if (Intrinsics.areEqual((Object)(node != null ? node.getNodeName() : null), (Object)"activity")) {
            Incident incident = IncidentKt.Incident((Context)((Context)context)).issue(DeepLinkInActivityDestination).location(context.getLocation((Node)element)).message("Do not attach a <deeplink> to an <activity> destination. Attach the deeplink directly to the second activity or the start destination of a nav host in the second activity instead.").scope((Object)context.getNameLocation((Node)element));
            context.report(incident);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(DeepLinkInActivityDestinationDetector.class, Scope.RESOURCE_FILE_SCOPE);
        DeepLinkInActivityDestination = Issue.Companion.create$default((Issue.Companion)companion, (String)"DeepLinkInActivityDestination", (String)"A <deeplink> should not be attached to an <activity> destination", (String)"Attaching a <deeplink> to an <activity> destination will never give \\\n                the right behavior when using an implicit deep link on another app's task \\\n                (where the system back should immediately take the user back to the app that \\\n                triggered the deep link). Instead, attach the deep link directly to \\\n                the second activity (either by manually writing the appropriate <intent-filter> \\\n                or by adding the <deeplink> to the start destination of a nav host in that second \\\n                activity).", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/runtime/lint/DeepLinkInActivityDestinationDetector$Companion;", "", "()V", "DeepLinkInActivityDestination", "Lcom/android/tools/lint/detector/api/Issue;", "getDeepLinkInActivityDestination", "()Lcom/android/tools/lint/detector/api/Issue;", "navigation-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getDeepLinkInActivityDestination() {
            return DeepLinkInActivityDestination;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

