/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.IdRes;
import androidx.annotation.NavigationRes;
import androidx.core.app.TaskStackBuilder;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavGraphNavigator;
import androidx.navigation.NavInflater;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002,-B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0011\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0007J\u001c\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001f\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u0018\u0010 \u001a\u00020\u00002\u0010\u0010#\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010%0$J\u001e\u0010&\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0007J\u001c\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00162\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0007J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000eJ\u0010\u0010(\u001a\u00020\u00002\b\b\u0001\u0010*\u001a\u00020\u0013J\b\u0010+\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Landroidx/navigation/NavDeepLinkBuilder;", "", "navController", "Landroidx/navigation/NavController;", "(Landroidx/navigation/NavController;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "destinations", "", "Landroidx/navigation/NavDeepLinkBuilder$DeepLinkDestination;", "globalArgs", "Landroid/os/Bundle;", "graph", "Landroidx/navigation/NavGraph;", "intent", "Landroid/content/Intent;", "addDestination", "destId", "", "args", "route", "", "createPendingIntent", "Landroid/app/PendingIntent;", "createTaskStackBuilder", "Landroidx/core/app/TaskStackBuilder;", "fillInIntent", "", "findDestination", "Landroidx/navigation/NavDestination;", "setArguments", "setComponentName", "componentName", "Landroid/content/ComponentName;", "activityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "setDestination", "destRoute", "setGraph", "navGraph", "navGraphId", "verifyAllDestinations", "DeepLinkDestination", "PermissiveNavigatorProvider", "navigation-runtime_release"})
@SourceDebugExtension(value={"SMAP\nNavDeepLinkBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDeepLinkBuilder.kt\nandroidx/navigation/NavDeepLinkBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,393:1\n1#2:394\n*E\n"})
public final class NavDeepLinkBuilder {
    @NotNull
    private final Context context;
    @NotNull
    private final Intent intent;
    @Nullable
    private NavGraph graph;
    @NotNull
    private final List<DeepLinkDestination> destinations;
    @Nullable
    private Bundle globalArgs;

    /*
     * WARNING - void declaration
     */
    public NavDeepLinkBuilder(@NotNull Context context) {
        void it;
        Intent intent;
        Intent intent2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        if (this.context instanceof Activity) {
            intent2 = new Intent(this.context, this.context.getClass());
        } else {
            Intent launchIntent = this.context.getPackageManager().getLaunchIntentForPackage(this.context.getPackageName());
            intent2 = launchIntent;
            if (intent2 == null) {
                intent2 = new Intent();
            }
        }
        Intent intent3 = intent = intent2;
        NavDeepLinkBuilder navDeepLinkBuilder = this;
        boolean bl = false;
        it.addFlags(0x10008000);
        navDeepLinkBuilder.intent = intent;
        this.destinations = new ArrayList();
    }

    public NavDeepLinkBuilder(@NotNull NavController navController) {
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        this(navController.getContext());
        this.graph = navController.getGraph();
    }

    @NotNull
    public final NavDeepLinkBuilder setComponentName(@NotNull Class<? extends Activity> activityClass) {
        Intrinsics.checkNotNullParameter(activityClass, (String)"activityClass");
        return this.setComponentName(new ComponentName(this.context, activityClass));
    }

    @NotNull
    public final NavDeepLinkBuilder setComponentName(@NotNull ComponentName componentName) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.intent.setComponent(componentName);
        return this;
    }

    @NotNull
    public final NavDeepLinkBuilder setGraph(@NavigationRes int navGraphId) {
        return this.setGraph(new NavInflater(this.context, new PermissiveNavigatorProvider()).inflate(navGraphId));
    }

    @NotNull
    public final NavDeepLinkBuilder setGraph(@NotNull NavGraph navGraph) {
        Intrinsics.checkNotNullParameter((Object)navGraph, (String)"navGraph");
        this.graph = navGraph;
        this.verifyAllDestinations();
        return this;
    }

    @JvmOverloads
    @NotNull
    public final NavDeepLinkBuilder setDestination(@IdRes int destId, @Nullable Bundle args) {
        this.destinations.clear();
        this.destinations.add(new DeepLinkDestination(destId, args));
        if (this.graph != null) {
            this.verifyAllDestinations();
        }
        return this;
    }

    public static /* synthetic */ NavDeepLinkBuilder setDestination$default(NavDeepLinkBuilder navDeepLinkBuilder, int n, Bundle bundle, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bundle = null;
        }
        return navDeepLinkBuilder.setDestination(n, bundle);
    }

    @JvmOverloads
    @NotNull
    public final NavDeepLinkBuilder setDestination(@NotNull String destRoute, @Nullable Bundle args) {
        Intrinsics.checkNotNullParameter((Object)destRoute, (String)"destRoute");
        this.destinations.clear();
        this.destinations.add(new DeepLinkDestination(NavDestination.Companion.createRoute(destRoute).hashCode(), args));
        if (this.graph != null) {
            this.verifyAllDestinations();
        }
        return this;
    }

    public static /* synthetic */ NavDeepLinkBuilder setDestination$default(NavDeepLinkBuilder navDeepLinkBuilder, String string, Bundle bundle, int n, Object object) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        return navDeepLinkBuilder.setDestination(string, bundle);
    }

    @JvmOverloads
    @NotNull
    public final NavDeepLinkBuilder addDestination(@IdRes int destId, @Nullable Bundle args) {
        this.destinations.add(new DeepLinkDestination(destId, args));
        if (this.graph != null) {
            this.verifyAllDestinations();
        }
        return this;
    }

    public static /* synthetic */ NavDeepLinkBuilder addDestination$default(NavDeepLinkBuilder navDeepLinkBuilder, int n, Bundle bundle, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bundle = null;
        }
        return navDeepLinkBuilder.addDestination(n, bundle);
    }

    @JvmOverloads
    @NotNull
    public final NavDeepLinkBuilder addDestination(@NotNull String route, @Nullable Bundle args) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        this.destinations.add(new DeepLinkDestination(NavDestination.Companion.createRoute(route).hashCode(), args));
        if (this.graph != null) {
            this.verifyAllDestinations();
        }
        return this;
    }

    public static /* synthetic */ NavDeepLinkBuilder addDestination$default(NavDeepLinkBuilder navDeepLinkBuilder, String string, Bundle bundle, int n, Object object) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        return navDeepLinkBuilder.addDestination(string, bundle);
    }

    private final NavDestination findDestination(@IdRes int destId) {
        ArrayDeque possibleDestinations = new ArrayDeque();
        NavGraph navGraph = this.graph;
        Intrinsics.checkNotNull((Object)navGraph);
        possibleDestinations.add((Object)navGraph);
        while (!possibleDestinations.isEmpty()) {
            NavDestination destination = (NavDestination)possibleDestinations.removeFirst();
            if (destination.getId() == destId) {
                return destination;
            }
            if (!(destination instanceof NavGraph)) continue;
            for (NavDestination child : (NavGraph)destination) {
                possibleDestinations.add((Object)child);
            }
        }
        return null;
    }

    private final void verifyAllDestinations() {
        for (DeepLinkDestination destination : this.destinations) {
            int destId = destination.getDestinationId();
            NavDestination node = this.findDestination(destId);
            if (node != null) continue;
            String dest = NavDestination.Companion.getDisplayName(this.context, destId);
            throw new IllegalArgumentException("Navigation destination " + dest + " cannot be found in the navigation graph " + this.graph);
        }
    }

    private final void fillInIntent() {
        List deepLinkIds = new ArrayList();
        ArrayList<Bundle> deepLinkArgs = new ArrayList<Bundle>();
        NavDestination previousDestination = null;
        for (DeepLinkDestination destination : this.destinations) {
            int destId = destination.getDestinationId();
            Bundle arguments = destination.getArguments();
            NavDestination node = this.findDestination(destId);
            if (node == null) {
                String dest = NavDestination.Companion.getDisplayName(this.context, destId);
                throw new IllegalArgumentException("Navigation destination " + dest + " cannot be found in the navigation graph " + this.graph);
            }
            for (int id2 : node.buildDeepLinkIds(previousDestination)) {
                deepLinkIds.add(id2);
                deepLinkArgs.add(arguments);
            }
            previousDestination = node;
        }
        int[] idArray = CollectionsKt.toIntArray((Collection)deepLinkIds);
        this.intent.putExtra("android-support-nav:controller:deepLinkIds", idArray);
        this.intent.putParcelableArrayListExtra("android-support-nav:controller:deepLinkArgs", deepLinkArgs);
    }

    @NotNull
    public final NavDeepLinkBuilder setArguments(@Nullable Bundle args) {
        this.globalArgs = args;
        this.intent.putExtra("android-support-nav:controller:deepLinkExtras", args);
        return this;
    }

    @NotNull
    public final TaskStackBuilder createTaskStackBuilder() {
        if (this.graph == null) {
            boolean $i$a$-checkNotNull-NavDeepLinkBuilder$createTaskStackBuilder$22 = false;
            String $i$a$-checkNotNull-NavDeepLinkBuilder$createTaskStackBuilder$22 = "You must call setGraph() before constructing the deep link";
            throw new IllegalStateException($i$a$-checkNotNull-NavDeepLinkBuilder$createTaskStackBuilder$22.toString());
        }
        if (!(!((Collection)this.destinations).isEmpty())) {
            boolean $i$a$-check-NavDeepLinkBuilder$createTaskStackBuilder$32 = false;
            String $i$a$-check-NavDeepLinkBuilder$createTaskStackBuilder$32 = "You must call setDestination() or addDestination() before constructing the deep link";
            throw new IllegalStateException($i$a$-check-NavDeepLinkBuilder$createTaskStackBuilder$32.toString());
        }
        this.fillInIntent();
        TaskStackBuilder taskStackBuilder = TaskStackBuilder.create((Context)this.context).addNextIntentWithParentStack(new Intent(this.intent));
        Intrinsics.checkNotNullExpressionValue((Object)taskStackBuilder, (String)"create(context).addNextI\u2026rentStack(Intent(intent))");
        TaskStackBuilder taskStackBuilder2 = taskStackBuilder;
        int n = taskStackBuilder2.getIntentCount();
        for (int index = 0; index < n; ++index) {
            Intent intent = taskStackBuilder2.editIntentAt(index);
            if (intent == null) continue;
            intent.putExtra("android-support-nav:controller:deepLinkIntent", (Parcelable)this.intent);
        }
        return taskStackBuilder2;
    }

    @NotNull
    public final PendingIntent createPendingIntent() {
        Object value;
        int requestCode = 0;
        Bundle bundle = this.globalArgs;
        if (bundle != null) {
            Bundle globalArgs = bundle;
            boolean bl = false;
            for (String key : globalArgs.keySet()) {
                Object object = value = globalArgs.get(key);
                requestCode = 31 * requestCode + (object != null ? object.hashCode() : 0);
            }
        }
        for (DeepLinkDestination destination : this.destinations) {
            int destId = destination.getDestinationId();
            requestCode = 31 * requestCode + destId;
            Bundle arguments = destination.getArguments();
            if (arguments == null) continue;
            for (String key : arguments.keySet()) {
                Object object = value = arguments.get(key);
                requestCode = 31 * requestCode + (object != null ? object.hashCode() : 0);
            }
        }
        PendingIntent pendingIntent = this.createTaskStackBuilder().getPendingIntent(requestCode, 0xC000000);
        Intrinsics.checkNotNull((Object)pendingIntent);
        return pendingIntent;
    }

    @JvmOverloads
    @NotNull
    public final NavDeepLinkBuilder setDestination(@IdRes int destId) {
        return NavDeepLinkBuilder.setDestination$default(this, destId, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final NavDeepLinkBuilder setDestination(@NotNull String destRoute) {
        Intrinsics.checkNotNullParameter((Object)destRoute, (String)"destRoute");
        return NavDeepLinkBuilder.setDestination$default(this, destRoute, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final NavDeepLinkBuilder addDestination(@IdRes int destId) {
        return NavDeepLinkBuilder.addDestination$default(this, destId, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final NavDeepLinkBuilder addDestination(@NotNull String route) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        return NavDeepLinkBuilder.addDestination$default(this, route, null, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Landroidx/navigation/NavDeepLinkBuilder$DeepLinkDestination;", "", "destinationId", "", "arguments", "Landroid/os/Bundle;", "(ILandroid/os/Bundle;)V", "getArguments", "()Landroid/os/Bundle;", "getDestinationId", "()I", "navigation-runtime_release"})
    private static final class DeepLinkDestination {
        private final int destinationId;
        @Nullable
        private final Bundle arguments;

        public DeepLinkDestination(int destinationId, @Nullable Bundle arguments) {
            this.destinationId = destinationId;
            this.arguments = arguments;
        }

        public final int getDestinationId() {
            return this.destinationId;
        }

        @Nullable
        public final Bundle getArguments() {
            return this.arguments;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0006\u001a\u0002H\u0007\"\u0010\b\u0000\u0010\u0007*\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/navigation/NavDeepLinkBuilder$PermissiveNavigatorProvider;", "Landroidx/navigation/NavigatorProvider;", "()V", "mDestNavigator", "Landroidx/navigation/Navigator;", "Landroidx/navigation/NavDestination;", "getNavigator", "T", "name", "", "(Ljava/lang/String;)Landroidx/navigation/Navigator;", "navigation-runtime_release"})
    private static final class PermissiveNavigatorProvider
    extends NavigatorProvider {
        @NotNull
        private final Navigator<NavDestination> mDestNavigator = (Navigator)new Navigator<NavDestination>(){

            @NotNull
            public NavDestination createDestination() {
                return new NavDestination("permissive");
            }

            @Nullable
            public NavDestination navigate(@NotNull NavDestination destination, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                throw new IllegalStateException("navigate is not supported");
            }

            public boolean popBackStack() {
                throw new IllegalStateException("popBackStack is not supported");
            }
        };

        public PermissiveNavigatorProvider() {
            this.addNavigator((Navigator)new NavGraphNavigator((NavigatorProvider)this));
        }

        @NotNull
        public <T extends Navigator<? extends NavDestination>> T getNavigator(@NotNull String name) {
            Navigator<NavDestination> navigator;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            try {
                navigator = super.getNavigator(name);
            }
            catch (IllegalStateException e) {
                Navigator<NavDestination> navigator2 = this.mDestNavigator;
                Intrinsics.checkNotNull(navigator2, (String)"null cannot be cast to non-null type T of androidx.navigation.NavDeepLinkBuilder.PermissiveNavigatorProvider.getNavigator");
                navigator = navigator2;
            }
            return (T)navigator;
        }
    }
}

