/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safeargs.gradle;

import androidx.navigation.safe.args.generator.ErrorMessage;
import androidx.navigation.safe.args.generator.GeneratorOutput;
import androidx.navigation.safe.args.generator.NavSafeArgsGeneratorKt;
import androidx.navigation.safeargs.gradle.ArgumentsGenerationTask;
import androidx.navigation.safeargs.gradle.Mapping;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J6\u0010$\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020)H\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020&0\"H\u0002J\u0015\u0010,\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b-J\u0016\u0010.\u001a\u00020\u001c2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020&0\"H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\tR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\t\u00a8\u00060"}, d2={"Landroidx/navigation/safeargs/gradle/ArgumentsGenerationTask;", "Lorg/gradle/api/DefaultTask;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/file/ProjectLayout;)V", "applicationId", "Lorg/gradle/api/provider/Property;", "", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "generateKotlin", "", "getGenerateKotlin", "incrementalFolder", "Lorg/gradle/api/file/DirectoryProperty;", "getIncrementalFolder", "()Lorg/gradle/api/file/DirectoryProperty;", "navigationFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getNavigationFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputDir", "getOutputDir", "rFilePackage", "getRFilePackage", "useAndroidX", "getUseAndroidX", "doFullTaskAction", "", "doIncrementalTaskAction", "inputs", "Lorg/gradle/work/InputChanges;", "failIfErrors", "errors", "", "Landroidx/navigation/safe/args/generator/ErrorMessage;", "generateArgs", "Lkotlin/Pair;", "Landroidx/navigation/safeargs/gradle/Mapping;", "navFiles", "", "Ljava/io/File;", "out", "readMappings", "taskAction", "taskAction$navigation_safe_args_gradle_plugin", "writeMappings", "mappings", "navigation-safe-args-gradle-plugin"})
public abstract class ArgumentsGenerationTask
extends DefaultTask {
    @NotNull
    private final ProjectLayout projectLayout;

    @Inject
    public ArgumentsGenerationTask(@NotNull ProjectLayout projectLayout) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        this.projectLayout = projectLayout;
    }

    @Input
    @NotNull
    public abstract Property<String> getRFilePackage();

    @Input
    @NotNull
    public abstract Property<String> getApplicationId();

    @Input
    @NotNull
    public abstract Property<Boolean> getUseAndroidX();

    @Input
    @NotNull
    public abstract Property<Boolean> getGenerateKotlin();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getNavigationFiles();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getIncrementalFolder();

    /*
     * WARNING - void declaration
     */
    private final Pair<List<Mapping>, List<ErrorMessage>> generateArgs(Collection<? extends File> navFiles, File out) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = navFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = this.getRFilePackage().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rFilePackage.get()");
            String string = (String)object;
            String string2 = (String)this.getApplicationId().getOrNull();
            if (string2 == null) {
                string2 = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"applicationId.orNull ?: \"\"");
            Object object2 = this.getUseAndroidX().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"useAndroidX.get()");
            boolean bl2 = (Boolean)object2;
            Object object3 = this.getGenerateKotlin().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"generateKotlin.get()");
            GeneratorOutput output = NavSafeArgsGeneratorKt.SafeArgsGenerator((String)string, (String)string2, (File)file, (File)out, (boolean)bl2, (boolean)((Boolean)object3)).generate();
            File file3 = this.projectLayout.getProjectDirectory().getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"projectLayout.projectDirectory.asFile");
            String string3 = FilesKt.relativeTo((File)file, (File)file3).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.relativeTo(\n       \u2026asFile\n            ).path");
            collection.add(TuplesKt.to((Object)new Mapping(string3, output.getFileNames()), (Object)output.getErrors()));
        }
        Pair pair = CollectionsKt.unzip((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        List mappings = (List)pair.component1();
        List errorLists = (List)pair.component2();
        return TuplesKt.to((Object)mappings, (Object)CollectionsKt.flatten((Iterable)errorLists));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeMappings(List<Mapping> mappings) {
        Object object = new File((File)this.getIncrementalFolder().getAsFile().get(), "file_mappings.json");
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            boolean bl = false;
            new Gson().toJson(mappings, (Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Mapping> readMappings() {
        List list;
        Type type2 = new TypeToken<List<? extends Mapping>>(){}.getType();
        File mappingsFile = new File((File)this.getIncrementalFolder().getAsFile().get(), "file_mappings.json");
        if (mappingsFile.exists()) {
            List list2;
            Object object = mappingsFile;
            Object object2 = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                InputStreamReader it = (InputStreamReader)object;
                boolean bl = false;
                List list3 = (List)new Gson().fromJson((Reader)it, type2);
                list2 = list3;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n            mappingsFi\u2026son(it, type) }\n        }");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @TaskAction
    public final void taskAction$navigation_safe_args_gradle_plugin(@NotNull InputChanges inputs) {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        if (inputs.isIncremental()) {
            this.doIncrementalTaskAction(inputs);
        } else {
            this.getLogger().info("Unable do incremental execution: full task run");
            this.doFullTaskAction();
        }
    }

    private final void doFullTaskAction() {
        File outputDirFile = (File)this.getOutputDir().getAsFile().get();
        if (outputDirFile.exists()) {
            Intrinsics.checkNotNullExpressionValue((Object)outputDirFile, (String)"outputDirFile");
            if (!FilesKt.deleteRecursively((File)outputDirFile)) {
                this.getLogger().warn("Failed to clear directory for navigation arguments");
            }
        }
        if (!outputDirFile.exists() && !outputDirFile.mkdirs()) {
            throw new GradleException("Failed to create directory for navigation arguments");
        }
        Set set = this.getNavigationFiles().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"navigationFiles.files");
        Collection collection = set;
        Intrinsics.checkNotNullExpressionValue((Object)outputDirFile, (String)"outputDirFile");
        Pair<List<Mapping>, List<ErrorMessage>> pair = this.generateArgs(collection, outputDirFile);
        List mappings = (List)pair.component1();
        List errors = (List)pair.component2();
        this.writeMappings(mappings);
        this.failIfErrors(errors);
    }

    /*
     * WARNING - void declaration
     */
    private final void doIncrementalTaskAction(InputChanges inputs) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Object element$iv$iv2;
        void $this$flatMapTo$iv$iv2;
        Set modifiedFiles = new LinkedHashSet();
        Set removedFiles = new LinkedHashSet();
        Iterable iterable = inputs.getFileChanges((FileCollection)this.getNavigationFiles());
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputs.getFileChanges(navigationFiles)");
        Iterable $this$forEach$iv2 = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            FileChange change = (FileChange)element$iv;
            boolean bl = false;
            if (change.getChangeType() == ChangeType.MODIFIED || change.getChangeType() == ChangeType.ADDED) {
                File file = change.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"change.file");
                modifiedFiles.add(file);
                continue;
            }
            if (change.getChangeType() != ChangeType.REMOVED) continue;
            File file = change.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"change.file");
            removedFiles.add(file);
        }
        List<Mapping> oldMapping = this.readMappings();
        Collection collection = modifiedFiles;
        Object object = this.getOutputDir().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDir.asFile.get()");
        Pair<List<Mapping>, List<ErrorMessage>> pair = this.generateArgs(collection, (File)object);
        List newMapping = (List)pair.component1();
        List errors = (List)pair.component2();
        Iterable $this$flatMap$iv = newMapping;
        boolean $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
            Mapping it = (Mapping)element$iv$iv2;
            boolean bl = false;
            Iterable list$iv$iv = it.getJavaFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set newJavaFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set changedInputs = SetsKt.plus((Set)removedFiles, (Iterable)modifiedFiles);
        Iterable $this$partition$iv = oldMapping;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Mapping it = (Mapping)element$iv;
            boolean bl = false;
            if (changedInputs.contains(new File(this.projectLayout.getProjectDirectory().getAsFile(), it.getNavFile()))) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair2 = new Pair(first$iv, second$iv);
        List modified = (List)pair2.component1();
        List unmodified = (List)pair2.component2();
        Iterable $this$flatMap$iv2 = modified;
        boolean $i$f$flatMap2 = false;
        element$iv$iv2 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv3 : $this$flatMapTo$iv$iv) {
            Mapping it = (Mapping)element$iv$iv3;
            boolean bl = false;
            Iterable list$iv$iv = it.getJavaFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            String name = (String)element$iv$iv3;
            boolean bl = false;
            if (!(!newJavaFiles.contains(name))) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String javaName = (String)element$iv;
            boolean bl = false;
            Object object2 = this.getGenerateKotlin().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"generateKotlin.get()");
            String fileExtension = (Boolean)object2 != false ? ".kt" : ".java";
            String fileName = StringsKt.replace$default((String)javaName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null) + fileExtension;
            File file = new File((File)this.getOutputDir().getAsFile().get(), fileName);
            if (!file.exists()) continue;
            file.delete();
        }
        this.writeMappings(CollectionsKt.plus((Collection)unmodified, (Iterable)newMapping));
        this.failIfErrors(errors);
    }

    private final void failIfErrors(List<ErrorMessage> errors) {
        if (!((Collection)errors).isEmpty()) {
            String errString2 = CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, (Function1)failIfErrors.errString.1.INSTANCE, (int)30, null);
            throw new GradleException("androidx.navigation.safeargs plugin failed.\n Following errors found: \n" + errString2);
        }
    }
}

