/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.ToolHandlerRegistry;

final class GestureRouter<T extends GestureDetector.OnGestureListener & GestureDetector.OnDoubleTapListener>
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener {
    private final ToolHandlerRegistry<T> mDelegates;

    GestureRouter(@NonNull T defaultDelegate) {
        Preconditions.checkArgument((defaultDelegate != null ? 1 : 0) != 0);
        this.mDelegates = new ToolHandlerRegistry<T>(defaultDelegate);
    }

    GestureRouter() {
        this(new GestureDetector.SimpleOnGestureListener());
    }

    public void register(int toolType, @Nullable T delegate) {
        this.mDelegates.set(toolType, delegate);
    }

    public boolean onSingleTapConfirmed(@NonNull MotionEvent e) {
        return ((GestureDetector.OnDoubleTapListener)((GestureDetector.OnGestureListener)this.mDelegates.get(e))).onSingleTapConfirmed(e);
    }

    public boolean onDoubleTap(@NonNull MotionEvent e) {
        return ((GestureDetector.OnDoubleTapListener)((GestureDetector.OnGestureListener)this.mDelegates.get(e))).onDoubleTap(e);
    }

    public boolean onDoubleTapEvent(@NonNull MotionEvent e) {
        return ((GestureDetector.OnDoubleTapListener)((GestureDetector.OnGestureListener)this.mDelegates.get(e))).onDoubleTapEvent(e);
    }

    public boolean onDown(@NonNull MotionEvent e) {
        return ((GestureDetector.OnGestureListener)this.mDelegates.get(e)).onDown(e);
    }

    public void onShowPress(@NonNull MotionEvent e) {
        ((GestureDetector.OnGestureListener)this.mDelegates.get(e)).onShowPress(e);
    }

    public boolean onSingleTapUp(@NonNull MotionEvent e) {
        return ((GestureDetector.OnGestureListener)this.mDelegates.get(e)).onSingleTapUp(e);
    }

    public boolean onScroll(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float distanceX, float distanceY) {
        return ((GestureDetector.OnGestureListener)this.mDelegates.get(e2)).onScroll(e1, e2, distanceX, distanceY);
    }

    public void onLongPress(@NonNull MotionEvent e) {
        ((GestureDetector.OnGestureListener)this.mDelegates.get(e)).onLongPress(e);
    }

    public boolean onFling(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float velocityX, float velocityY) {
        return ((GestureDetector.OnGestureListener)this.mDelegates.get(e2)).onFling(e1, e2, velocityX, velocityY);
    }
}

