/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class ItemKeyProvider<K> {
    public static final int SCOPE_MAPPED = 0;
    public static final int SCOPE_CACHED = 1;
    private final int mScope;

    protected ItemKeyProvider(int scope) {
        Preconditions.checkArgument((scope == 0 || scope == 1 ? 1 : 0) != 0);
        this.mScope = scope;
    }

    final boolean hasAccess(int scope) {
        return scope == this.mScope;
    }

    @Nullable
    public abstract K getKey(int var1);

    public abstract int getPosition(@NonNull K var1);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Scope {
    }
}

