/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.util.SparseArray;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.widget.RecyclerView;

public final class StableIdKeyProvider
extends ItemKeyProvider<Long> {
    private static final String TAG = "StableIdKeyProvider";
    private final SparseArray<Long> mPositionToKey = new SparseArray();
    private final LongSparseArray<Integer> mKeyToPosition = new LongSparseArray();
    private final RecyclerView mRecyclerView;

    public StableIdKeyProvider(@NonNull RecyclerView recyclerView) {
        super(1);
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.addOnChildAttachStateChangeListener(new RecyclerView.OnChildAttachStateChangeListener(){

            public void onChildViewAttachedToWindow(View view) {
                StableIdKeyProvider.this.onAttached(view);
            }

            public void onChildViewDetachedFromWindow(View view) {
                StableIdKeyProvider.this.onDetached(view);
            }
        });
    }

    void onAttached(@NonNull View view) {
        RecyclerView.ViewHolder holder = this.mRecyclerView.findContainingViewHolder(view);
        if (holder == null) {
            return;
        }
        int position = holder.getAdapterPosition();
        long id = holder.getItemId();
        if (position != -1 && id != -1L) {
            this.mPositionToKey.put(position, (Object)id);
            this.mKeyToPosition.put(id, (Object)position);
        }
    }

    void onDetached(@NonNull View view) {
        RecyclerView.ViewHolder holder = this.mRecyclerView.findContainingViewHolder(view);
        if (holder == null) {
            return;
        }
        int position = holder.getAdapterPosition();
        long id = holder.getItemId();
        if (position != -1 && id != -1L) {
            this.mPositionToKey.delete(position);
            this.mKeyToPosition.remove(id);
        }
    }

    @Override
    @Nullable
    public Long getKey(int position) {
        return (Long)this.mPositionToKey.get(position, null);
    }

    @Override
    public int getPosition(@NonNull Long key) {
        return (Integer)this.mKeyToPosition.get(key.longValue(), (Object)-1);
    }
}

