/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import java.util.Arrays;
import java.util.List;

final class ToolHandlerRegistry<T> {
    private final List<T> mHandlers = Arrays.asList(null, null, null, null, null);
    private final T mDefault;

    ToolHandlerRegistry(@NonNull T defaultDelegate) {
        Preconditions.checkArgument((defaultDelegate != null ? 1 : 0) != 0);
        this.mDefault = defaultDelegate;
    }

    void set(int toolType, @Nullable T delegate) {
        Preconditions.checkArgument((toolType >= 0 && toolType <= 4 ? 1 : 0) != 0);
        Preconditions.checkState((this.mHandlers.get(toolType) == null ? 1 : 0) != 0);
        this.mHandlers.set(toolType, delegate);
    }

    T get(@NonNull MotionEvent e) {
        T d = this.mHandlers.get(e.getToolType(0));
        return d != null ? d : this.mDefault;
    }
}

