/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.NonNull;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

final class QueryInterceptorStatement
implements SupportSQLiteStatement {
    private final SupportSQLiteStatement mDelegate;
    private final RoomDatabase.QueryCallback mQueryCallback;
    private final String mSqlStatement;
    private final List<Object> mBindArgsCache = new ArrayList<Object>();
    private final Executor mQueryCallbackExecutor;

    QueryInterceptorStatement(@NonNull SupportSQLiteStatement compileStatement, @NonNull RoomDatabase.QueryCallback queryCallback, String sqlStatement, @NonNull Executor queryCallbackExecutor) {
        this.mDelegate = compileStatement;
        this.mQueryCallback = queryCallback;
        this.mSqlStatement = sqlStatement;
        this.mQueryCallbackExecutor = queryCallbackExecutor;
    }

    public void execute() {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(this.mSqlStatement, this.mBindArgsCache));
        this.mDelegate.execute();
    }

    public int executeUpdateDelete() {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(this.mSqlStatement, this.mBindArgsCache));
        return this.mDelegate.executeUpdateDelete();
    }

    public long executeInsert() {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(this.mSqlStatement, this.mBindArgsCache));
        return this.mDelegate.executeInsert();
    }

    public long simpleQueryForLong() {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(this.mSqlStatement, this.mBindArgsCache));
        return this.mDelegate.simpleQueryForLong();
    }

    public String simpleQueryForString() {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(this.mSqlStatement, this.mBindArgsCache));
        return this.mDelegate.simpleQueryForString();
    }

    public void bindNull(int index) {
        this.saveArgsToCache(index, this.mBindArgsCache.toArray());
        this.mDelegate.bindNull(index);
    }

    public void bindLong(int index, long value) {
        this.saveArgsToCache(index, value);
        this.mDelegate.bindLong(index, value);
    }

    public void bindDouble(int index, double value) {
        this.saveArgsToCache(index, value);
        this.mDelegate.bindDouble(index, value);
    }

    public void bindString(int index, String value) {
        this.saveArgsToCache(index, value);
        this.mDelegate.bindString(index, value);
    }

    public void bindBlob(int index, byte[] value) {
        this.saveArgsToCache(index, value);
        this.mDelegate.bindBlob(index, value);
    }

    public void clearBindings() {
        this.mBindArgsCache.clear();
        this.mDelegate.clearBindings();
    }

    public void close() throws IOException {
        this.mDelegate.close();
    }

    private void saveArgsToCache(int bindIndex, Object value) {
        int index = bindIndex - 1;
        if (index >= this.mBindArgsCache.size()) {
            for (int i = this.mBindArgsCache.size(); i <= index; ++i) {
                this.mBindArgsCache.add(null);
            }
        }
        this.mBindArgsCache.set(index, value);
    }
}

