/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;

public class Room {
    static final String LOG_TAG = "ROOM";
    public static final String MASTER_TABLE_NAME = "room_master_table";
    private static final String CURSOR_CONV_SUFFIX = "_CursorConverter";

    @NonNull
    public static <T extends RoomDatabase> RoomDatabase.Builder<T> databaseBuilder(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot build a database with null or empty name. If you are trying to create an in memory database, use Room.inMemoryDatabaseBuilder");
        }
        return new RoomDatabase.Builder<T>(context, klass, name);
    }

    @NonNull
    public static <T extends RoomDatabase> RoomDatabase.Builder<T> inMemoryDatabaseBuilder(@NonNull Context context, @NonNull Class<T> klass) {
        return new RoomDatabase.Builder<T>(context, klass, null);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static <T, C> T getGeneratedImplementation(@NonNull Class<C> klass, @NonNull String suffix) {
        String fullPackage = klass.getPackage().getName();
        String name = klass.getCanonicalName();
        String postPackageName = fullPackage.isEmpty() ? name : name.substring(fullPackage.length() + 1);
        String implName = postPackageName.replace('.', '_') + suffix;
        try {
            String fullClassName = fullPackage.isEmpty() ? implName : fullPackage + "." + implName;
            Class<?> aClass = Class.forName(fullClassName, true, klass.getClassLoader());
            return (T)aClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot find implementation for " + klass.getCanonicalName() + ". " + implName + " does not exist");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access the constructor" + klass.getCanonicalName());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to create an instance of " + klass.getCanonicalName());
        }
    }

    @Deprecated
    public Room() {
    }
}

