/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0001?B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000204J%\u00106\u001a\u0002H7\"\u0004\b\u0000\u001072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H709\u00a2\u0006\u0002\u0010:J\u0006\u0010;\u001a\u00020\rJ\u000e\u0010<\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010=\u001a\u0002042\u0006\u0010>\u001a\u00020\u000bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0004\u0018\u00010\r8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u001e\u0010\u001f\u001a\u00020\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010+\u001a\u00020,8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0014\u00101\u001a\u00020,8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010.\u00a8\u0006@"}, d2={"Landroidx/room/AutoCloser;", "", "autoCloseTimeoutAmount", "", "autoCloseTimeUnit", "Ljava/util/concurrent/TimeUnit;", "autoCloseExecutor", "Ljava/util/concurrent/Executor;", "(JLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/Executor;)V", "autoCloseTimeoutInMs", "autoCloser", "Ljava/lang/Runnable;", "delegateDatabase", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "getDelegateDatabase$room_runtime_release", "()Landroidx/sqlite/db/SupportSQLiteDatabase;", "setDelegateDatabase$room_runtime_release", "(Landroidx/sqlite/db/SupportSQLiteDatabase;)V", "delegateOpenHelper", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "getDelegateOpenHelper", "()Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "setDelegateOpenHelper", "(Landroidx/sqlite/db/SupportSQLiteOpenHelper;)V", "executeAutoCloser", "executor", "handler", "Landroid/os/Handler;", "isActive", "", "()Z", "lastDecrementRefCountTimeStamp", "getLastDecrementRefCountTimeStamp$room_runtime_release", "()J", "setLastDecrementRefCountTimeStamp$room_runtime_release", "(J)V", "lock", "manuallyClosed", "onAutoCloseCallback", "getOnAutoCloseCallback$room_runtime_release", "()Ljava/lang/Runnable;", "setOnAutoCloseCallback$room_runtime_release", "(Ljava/lang/Runnable;)V", "refCount", "", "getRefCount$room_runtime_release", "()I", "setRefCount$room_runtime_release", "(I)V", "refCountForTest", "getRefCountForTest$room_runtime_release", "closeDatabaseIfOpen", "", "decrementCountAndScheduleClose", "executeRefCountingFunction", "V", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "incrementCountAndEnsureDbIsOpen", "init", "setAutoCloseCallback", "onAutoClose", "Companion", "room-runtime_release"})
public final class AutoCloser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public SupportSQLiteOpenHelper delegateOpenHelper;
    @NotNull
    private final Handler handler;
    @Nullable
    private Runnable onAutoCloseCallback;
    @NotNull
    private final Object lock;
    private long autoCloseTimeoutInMs;
    @NotNull
    private final Executor executor;
    @GuardedBy(value="lock")
    private int refCount;
    @GuardedBy(value="lock")
    private long lastDecrementRefCountTimeStamp;
    @GuardedBy(value="lock")
    @Nullable
    private SupportSQLiteDatabase delegateDatabase;
    private boolean manuallyClosed;
    @NotNull
    private final Runnable executeAutoCloser;
    @NotNull
    private final Runnable autoCloser;
    @NotNull
    public static final String autoCloseBug = "https://issuetracker.google.com/issues/new?component=413107&template=1096568";

    public AutoCloser(long autoCloseTimeoutAmount, @NotNull TimeUnit autoCloseTimeUnit, @NotNull Executor autoCloseExecutor) {
        Intrinsics.checkNotNullParameter((Object)((Object)autoCloseTimeUnit), (String)"autoCloseTimeUnit");
        Intrinsics.checkNotNullParameter((Object)autoCloseExecutor, (String)"autoCloseExecutor");
        this.handler = new Handler(Looper.getMainLooper());
        this.lock = new Object();
        this.autoCloseTimeoutInMs = autoCloseTimeUnit.toMillis(autoCloseTimeoutAmount);
        this.executor = autoCloseExecutor;
        this.lastDecrementRefCountTimeStamp = SystemClock.uptimeMillis();
        this.executeAutoCloser = () -> AutoCloser.executeAutoCloser$lambda$0(this);
        this.autoCloser = () -> AutoCloser.autoCloser$lambda$3(this);
    }

    @NotNull
    public final SupportSQLiteOpenHelper getDelegateOpenHelper() {
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.delegateOpenHelper;
        if (supportSQLiteOpenHelper != null) {
            return supportSQLiteOpenHelper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"delegateOpenHelper");
        return null;
    }

    public final void setDelegateOpenHelper(@NotNull SupportSQLiteOpenHelper supportSQLiteOpenHelper) {
        Intrinsics.checkNotNullParameter((Object)supportSQLiteOpenHelper, (String)"<set-?>");
        this.delegateOpenHelper = supportSQLiteOpenHelper;
    }

    @Nullable
    public final Runnable getOnAutoCloseCallback$room_runtime_release() {
        return this.onAutoCloseCallback;
    }

    public final void setOnAutoCloseCallback$room_runtime_release(@Nullable Runnable runnable) {
        this.onAutoCloseCallback = runnable;
    }

    public final int getRefCount$room_runtime_release() {
        return this.refCount;
    }

    public final void setRefCount$room_runtime_release(int n) {
        this.refCount = n;
    }

    public final long getLastDecrementRefCountTimeStamp$room_runtime_release() {
        return this.lastDecrementRefCountTimeStamp;
    }

    public final void setLastDecrementRefCountTimeStamp$room_runtime_release(long l) {
        this.lastDecrementRefCountTimeStamp = l;
    }

    @Nullable
    public final SupportSQLiteDatabase getDelegateDatabase$room_runtime_release() {
        return this.delegateDatabase;
    }

    public final void setDelegateDatabase$room_runtime_release(@Nullable SupportSQLiteDatabase supportSQLiteDatabase) {
        this.delegateDatabase = supportSQLiteDatabase;
    }

    public final void init(@NotNull SupportSQLiteOpenHelper delegateOpenHelper) {
        Intrinsics.checkNotNullParameter((Object)delegateOpenHelper, (String)"delegateOpenHelper");
        this.setDelegateOpenHelper(delegateOpenHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <V> V executeRefCountingFunction(@NotNull Function1<? super SupportSQLiteDatabase, ? extends V> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            object = block.invoke((Object)this.incrementCountAndEnsureDbIsOpen());
        }
        finally {
            this.decrementCountAndScheduleClose();
        }
        return (V)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final SupportSQLiteDatabase incrementCountAndEnsureDbIsOpen() {
        Object object = this.lock;
        synchronized (object) {
            SupportSQLiteDatabase supportSQLiteDatabase;
            boolean bl = false;
            this.handler.removeCallbacks(this.executeAutoCloser);
            int n = this.refCount;
            this.refCount = n + 1;
            if (!(!this.manuallyClosed)) {
                boolean $i$a$-check-AutoCloser$incrementCountAndEnsureDbIsOpen$1$22 = false;
                String $i$a$-check-AutoCloser$incrementCountAndEnsureDbIsOpen$1$22 = "Attempting to open already closed database.";
                throw new IllegalStateException($i$a$-check-AutoCloser$incrementCountAndEnsureDbIsOpen$1$22.toString());
            }
            SupportSQLiteDatabase supportSQLiteDatabase2 = this.delegateDatabase;
            if (supportSQLiteDatabase2 != null) {
                SupportSQLiteDatabase it = supportSQLiteDatabase2;
                boolean bl2 = false;
                if (it.isOpen()) {
                    return it;
                }
            }
            SupportSQLiteDatabase it = supportSQLiteDatabase = this.getDelegateOpenHelper().getWritableDatabase();
            boolean bl3 = false;
            this.delegateDatabase = it;
            return supportSQLiteDatabase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrementCountAndScheduleClose() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!(this.refCount > 0)) {
                boolean bl2 = false;
                String string = "ref count is 0 or lower but we're supposed to decrement";
                throw new IllegalStateException(string.toString());
            }
            int n = this.refCount;
            this.refCount = n + -1;
            if (this.refCount == 0) {
                if (this.delegateDatabase == null) {
                    return;
                }
                this.handler.postDelayed(this.executeAutoCloser, this.autoCloseTimeoutInMs);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeDatabaseIfOpen() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.manuallyClosed = true;
            SupportSQLiteDatabase supportSQLiteDatabase = this.delegateDatabase;
            if (supportSQLiteDatabase != null) {
                supportSQLiteDatabase.close();
            }
            this.delegateDatabase = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isActive() {
        return !this.manuallyClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final int getRefCountForTest$room_runtime_release() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            int n = this.refCount;
            return n;
        }
    }

    public final void setAutoCloseCallback(@NotNull Runnable onAutoClose) {
        Intrinsics.checkNotNullParameter((Object)onAutoClose, (String)"onAutoClose");
        this.onAutoCloseCallback = onAutoClose;
    }

    private static final void executeAutoCloser$lambda$0(AutoCloser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.executor.execute(this$0.autoCloser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void autoCloser$lambda$3(AutoCloser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.lock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            if (SystemClock.uptimeMillis() - this$0.lastDecrementRefCountTimeStamp < this$0.autoCloseTimeoutInMs) {
                return;
            }
            if (this$0.refCount != 0) {
                return;
            }
            Runnable runnable = this$0.onAutoCloseCallback;
            if (runnable != null) {
                runnable.run();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new IllegalStateException("onAutoCloseCallback is null but it should have been set before use. Please file a bug against Room at: https://issuetracker.google.com/issues/new?component=413107&template=1096568".toString());
            }
            SupportSQLiteDatabase supportSQLiteDatabase = this$0.delegateDatabase;
            if (supportSQLiteDatabase != null) {
                SupportSQLiteDatabase it = supportSQLiteDatabase;
                boolean bl2 = false;
                if (it.isOpen()) {
                    it.close();
                }
            }
            this$0.delegateDatabase = null;
            Unit unit2 = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/room/AutoCloser$Companion;", "", "()V", "autoCloseBug", "", "room-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

