/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Action;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class RxRoom {
    public static final Object NOTHING = new Object();

    public static Flowable<Object> createFlowable(final RoomDatabase database, final String ... tableNames) {
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Object>(){

            public void subscribe(final FlowableEmitter<Object> emitter) throws Exception {
                final InvalidationTracker.Observer observer = new InvalidationTracker.Observer(tableNames){

                    public void onInvalidated(@NonNull Set<String> tables) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(NOTHING);
                        }
                    }
                };
                if (!emitter.isCancelled()) {
                    database.getInvalidationTracker().addObserver(observer);
                    emitter.setDisposable(Disposables.fromAction((Action)new Action(){

                        public void run() throws Exception {
                            database.getInvalidationTracker().removeObserver(observer);
                        }
                    }));
                }
                if (!emitter.isCancelled()) {
                    emitter.onNext(NOTHING);
                }
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static <T> Flowable<T> createFlowable(RoomDatabase database, String[] tableNames, Callable<T> callable) {
        return RxRoom.createFlowable(database, false, tableNames, callable);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static <T> Flowable<T> createFlowable(RoomDatabase database, boolean inTransaction, String[] tableNames, Callable<T> callable) {
        Scheduler scheduler = Schedulers.from((Executor)RxRoom.getExecutor(database, inTransaction));
        final Maybe maybe = Maybe.fromCallable(callable);
        return RxRoom.createFlowable(database, tableNames).subscribeOn(scheduler).unsubscribeOn(scheduler).observeOn(scheduler).flatMapMaybe(new Function<Object, MaybeSource<T>>(){

            public MaybeSource<T> apply(Object o) throws Exception {
                return maybe;
            }
        });
    }

    public static Observable<Object> createObservable(final RoomDatabase database, final String ... tableNames) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(final ObservableEmitter<Object> emitter) throws Exception {
                final InvalidationTracker.Observer observer = new InvalidationTracker.Observer(tableNames){

                    public void onInvalidated(@NonNull Set<String> tables) {
                        emitter.onNext(NOTHING);
                    }
                };
                database.getInvalidationTracker().addObserver(observer);
                emitter.setDisposable(Disposables.fromAction((Action)new Action(){

                    public void run() throws Exception {
                        database.getInvalidationTracker().removeObserver(observer);
                    }
                }));
                emitter.onNext(NOTHING);
            }
        });
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static <T> Observable<T> createObservable(RoomDatabase database, String[] tableNames, Callable<T> callable) {
        return RxRoom.createObservable(database, false, tableNames, callable);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static <T> Observable<T> createObservable(RoomDatabase database, boolean inTransaction, String[] tableNames, Callable<T> callable) {
        Scheduler scheduler = Schedulers.from((Executor)RxRoom.getExecutor(database, inTransaction));
        final Maybe maybe = Maybe.fromCallable(callable);
        return RxRoom.createObservable(database, tableNames).subscribeOn(scheduler).unsubscribeOn(scheduler).observeOn(scheduler).flatMapMaybe(new Function<Object, MaybeSource<T>>(){

            public MaybeSource<T> apply(Object o) throws Exception {
                return maybe;
            }
        });
    }

    private static Executor getExecutor(RoomDatabase database, boolean inTransaction) {
        if (inTransaction) {
            return database.getTransactionExecutor();
        }
        return database.getQueryExecutor();
    }

    @Deprecated
    public RxRoom() {
    }
}

