/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.app;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.test.InstrumentationRegistry;
import androidx.test.core.app.InstrumentationActivityInvoker$$Lambda$0;
import androidx.test.core.app.InstrumentationActivityInvoker$$Lambda$1;
import androidx.test.core.app.InstrumentationActivityInvoker$$Lambda$2;
import androidx.test.internal.platform.app.ActivityInvoker;
import androidx.test.internal.platform.app.ActivityInvoker$;
import androidx.test.internal.util.Checks;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class InstrumentationActivityInvoker
implements ActivityInvoker {
    private static final long TIMEOUT_SECONDS = 45L;
    private static final String EMPTY_ACTIVITY_RESUMED = "androidx.test.core.app.InstrumentationActivityInvoker.EMPTY_ACTIVITY_RESUMED";
    private static final String EMPTY_FLOATING_ACTIVITY_RESUMED = "androidx.test.core.app.InstrumentationActivityInvoker.EMPTY_FLOATING_ACTIVITY_RESUMED";
    private static final String FINISH_EMPTY_ACTIVITIES = "androidx.test.core.app.InstrumentationActivityInvoker.FINISH_EMPTY_ACTIVITIES";

    InstrumentationActivityInvoker() {
    }

    public void startActivity(Intent intent) {
        InstrumentationRegistry.getTargetContext().sendBroadcast(new Intent(FINISH_EMPTY_ACTIVITIES));
        InstrumentationRegistry.getTargetContext().startActivity(intent.setFlags(0x10008000));
    }

    public void resumeActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED, Stage.STOPPED);
        InstrumentationRegistry.getTargetContext().sendBroadcast(new Intent(FINISH_EMPTY_ACTIVITIES));
    }

    public void pauseActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED);
        final CountDownLatch latch = new CountDownLatch(1);
        BroadcastReceiver receiver = new BroadcastReceiver(this){

            public void onReceive(Context context, Intent intent) {
                latch.countDown();
            }
        };
        InstrumentationRegistry.getTargetContext().registerReceiver(receiver, new IntentFilter(EMPTY_FLOATING_ACTIVITY_RESUMED));
        InstrumentationRegistry.getTargetContext().startActivity(this.getIntentForActivity(EmptyFloatingActivity.class).setFlags(0x10008000));
        try {
            latch.await(45L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError("Failed to pause activity", e);
        }
        finally {
            InstrumentationRegistry.getTargetContext().unregisterReceiver(receiver);
        }
    }

    public void stopActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED, Stage.STOPPED);
        final CountDownLatch latch = new CountDownLatch(1);
        BroadcastReceiver receiver = new BroadcastReceiver(this){

            public void onReceive(Context context, Intent intent) {
                latch.countDown();
            }
        };
        InstrumentationRegistry.getTargetContext().registerReceiver(receiver, new IntentFilter(EMPTY_ACTIVITY_RESUMED));
        InstrumentationRegistry.getTargetContext().startActivity(this.getIntentForActivity(EmptyActivity.class).setFlags(0x10008000));
        try {
            latch.await(45L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError("Failed to stop activity", e);
        }
        finally {
            InstrumentationRegistry.getTargetContext().unregisterReceiver(receiver);
        }
    }

    public void recreateActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED, Stage.STOPPED);
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)new InstrumentationActivityInvoker$$Lambda$0(activity));
    }

    public void finishActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED, Stage.STOPPED);
        this.stopActivity(activity);
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)new InstrumentationActivityInvoker$$Lambda$1(activity));
        InstrumentationRegistry.getTargetContext().sendBroadcast(new Intent(FINISH_EMPTY_ACTIVITIES));
    }

    private static void checkActivityStageIsIn(Activity activity, Stage ... expected) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, new HashSet<Stage>(Arrays.asList(expected)));
    }

    private static void checkActivityStageIsIn(Activity activity, Set<Stage> expected) {
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)new InstrumentationActivityInvoker$$Lambda$2(activity, expected));
    }

    static final /* synthetic */ void lambda$checkActivityStageIsIn$2$InstrumentationActivityInvoker(Activity activity, Set expected) {
        Stage stage = ActivityLifecycleMonitorRegistry.getInstance().getLifecycleStageOf(activity);
        Checks.checkState((boolean)expected.contains(stage), (String)"Activity's stage must be %s but was %s", (Object[])new Object[]{expected, stage});
    }

    static final /* synthetic */ void lambda$finishActivity$1$InstrumentationActivityInvoker(Activity activity) {
        activity.finish();
    }

    static final /* synthetic */ void lambda$recreateActivity$0$InstrumentationActivityInvoker(Activity activity) {
        activity.recreate();
    }

    public Intent getIntentForActivity(Class clazz) {
        return ActivityInvoker$.CC.getIntentForActivity((ActivityInvoker)this, (Class)clazz);
    }

    public static class EmptyFloatingActivity
    extends Activity {
        private final BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                EmptyFloatingActivity.this.finish();
            }
        };

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.registerReceiver(this.receiver, new IntentFilter(InstrumentationActivityInvoker.FINISH_EMPTY_ACTIVITIES));
        }

        protected void onResume() {
            super.onResume();
            this.sendBroadcast(new Intent(InstrumentationActivityInvoker.EMPTY_FLOATING_ACTIVITY_RESUMED));
        }

        protected void onDestroy() {
            super.onDestroy();
            this.unregisterReceiver(this.receiver);
        }
    }

    public static class EmptyActivity
    extends Activity {
        private final BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                EmptyActivity.this.finish();
            }
        };

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.registerReceiver(this.receiver, new IntentFilter(InstrumentationActivityInvoker.FINISH_EMPTY_ACTIVITIES));
        }

        protected void onResume() {
            super.onResume();
            this.sendBroadcast(new Intent(InstrumentationActivityInvoker.EMPTY_ACTIVITY_RESUMED));
        }

        protected void onDestroy() {
            super.onDestroy();
            this.unregisterReceiver(this.receiver);
        }
    }
}

