/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.content.pm;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import androidx.annotation.Nullable;
import androidx.test.core.content.pm.ApplicationInfoBuilder;
import androidx.test.internal.util.Checks;

public final class PackageInfoBuilder {
    @Nullable
    private String packageName;
    @Nullable
    private ApplicationInfo applicationInfo;

    private PackageInfoBuilder() {
    }

    public static PackageInfoBuilder newBuilder() {
        return new PackageInfoBuilder();
    }

    public PackageInfoBuilder setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public PackageInfoBuilder setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    public PackageInfo build() {
        Checks.checkNotNull((Object)this.packageName, (Object)"Mandatory field 'packageName' missing.");
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = this.packageName;
        if (this.applicationInfo == null) {
            this.applicationInfo = ApplicationInfoBuilder.newBuilder().setPackageName(this.packageName).build();
        }
        packageInfo.applicationInfo = this.applicationInfo;
        Checks.checkState((boolean)packageInfo.packageName.equals(packageInfo.applicationInfo.packageName), (Object)"Field 'packageName' must match field 'applicationInfo.packageName'");
        return packageInfo;
    }
}

