/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.view;

import android.os.SystemClock;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;

public class MotionEventBuilder {
    private long downTime = 0L;
    private long eventTime = SystemClock.uptimeMillis();
    private int action = 0;
    private int actionIndex = -1;
    private List<MotionEvent.PointerProperties> pointerPropertiesList = new ArrayList<MotionEvent.PointerProperties>();
    private List<MotionEvent.PointerCoords> pointerCoordsList = new ArrayList<MotionEvent.PointerCoords>();
    private int metaState = 0;
    private int buttonState = 0;
    private float xPrecision = 0.0f;
    private float yPrecision = 0.0f;
    private int deviceId = 0;
    private int edgeFlags = 0;
    private int source = 0;
    private int flags = 0;

    private MotionEventBuilder() {
    }

    public static MotionEventBuilder newBuilder() {
        return new MotionEventBuilder();
    }

    public MotionEventBuilder setDownTime(long downTime) {
        this.downTime = downTime;
        return this;
    }

    public MotionEventBuilder setEventTime(long eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public MotionEventBuilder setAction(int action) {
        this.action = action;
        return this;
    }

    public MotionEventBuilder setActionIndex(int pointerIndex) {
        MotionEventBuilder.checkState(pointerIndex <= 255, "pointerIndex must be less than 0xff");
        this.actionIndex = pointerIndex;
        return this;
    }

    public MotionEventBuilder setMetaState(int metastate) {
        this.metaState = metastate;
        return this;
    }

    public MotionEventBuilder setButtonState(int buttonState) {
        this.buttonState = buttonState;
        return this;
    }

    public MotionEventBuilder setXPrecision(float xPrecision) {
        this.xPrecision = xPrecision;
        return this;
    }

    public MotionEventBuilder setYPrecision(float yPrecision) {
        this.yPrecision = yPrecision;
        return this;
    }

    public MotionEventBuilder setDeviceId(int deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public MotionEventBuilder setEdgeFlags(int edgeFlags) {
        this.edgeFlags = edgeFlags;
        return this;
    }

    public MotionEventBuilder setSource(int source) {
        this.source = source;
        return this;
    }

    public MotionEventBuilder setFlags(int flags) {
        this.flags = flags;
        return this;
    }

    public MotionEventBuilder setPointer(float x, float y) {
        MotionEvent.PointerProperties pointerProperties = new MotionEvent.PointerProperties();
        pointerProperties.id = this.pointerPropertiesList.size();
        MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
        pointerCoords.x = x;
        pointerCoords.y = y;
        return this.setPointer(pointerProperties, pointerCoords);
    }

    public MotionEventBuilder setPointer(MotionEvent.PointerProperties pointerProperties, MotionEvent.PointerCoords pointerCoords) {
        this.pointerPropertiesList.add(pointerProperties);
        this.pointerCoordsList.add(pointerCoords);
        return this;
    }

    public MotionEvent build() {
        if (this.pointerPropertiesList.size() == 0) {
            this.setPointer(0.0f, 0.0f);
        }
        if (this.actionIndex != -1) {
            this.action |= this.actionIndex << 8;
        }
        return MotionEvent.obtain((long)this.downTime, (long)this.eventTime, (int)this.action, (int)this.pointerPropertiesList.size(), (MotionEvent.PointerProperties[])this.pointerPropertiesList.toArray(new MotionEvent.PointerProperties[this.pointerPropertiesList.size()]), (MotionEvent.PointerCoords[])this.pointerCoordsList.toArray(new MotionEvent.PointerCoords[this.pointerCoordsList.size()]), (int)this.metaState, (int)this.buttonState, (float)this.xPrecision, (float)this.yPrecision, (int)this.deviceId, (int)this.edgeFlags, (int)this.source, (int)this.flags);
    }

    private static void checkState(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }
}

