/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.truth.os;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.test.ext.truth.os.BundleSubject$$ExternalSyntheticLambda0;
import androidx.test.ext.truth.os.ParcelableSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;

public final class BundleSubject
extends Subject {
    private final Bundle actual;

    public static BundleSubject assertThat(Bundle bundle) {
        return (BundleSubject)Truth.assertAbout(BundleSubject.bundles()).that((Object)bundle);
    }

    public <T extends Parcelable> ParcelableSubject<T> parcelable(String key) {
        return (ParcelableSubject)this.check("getParcelable(%s)", new Object[]{key}).about(ParcelableSubject.parcelables()).that((Object)this.actual.getParcelable(key));
    }

    public BooleanSubject bool(String key) {
        return this.check("getBoolean(%s)", new Object[]{key}).that(Boolean.valueOf(this.actual.getBoolean(key)));
    }

    @NonNull
    public DoubleSubject doubleFloat(@NonNull String key) {
        return this.check("getDouble(%s)", new Object[]{key}).that(Double.valueOf(this.actual.getDouble(key)));
    }

    public IntegerSubject integer(String key) {
        return this.check("getInt(%s)", new Object[]{key}).that(Integer.valueOf(this.actual.getInt(key)));
    }

    public IterableSubject parcelableArrayList(String key) {
        return this.check("getParcelableArrayList(%s)", new Object[]{key}).that((Iterable)this.actual.getParcelableArrayList(key));
    }

    public IterableSubject stringArrayList(String key) {
        return this.check("getStringArrayList(%s)", new Object[]{key}).that((Iterable)this.actual.getStringArrayList(key));
    }

    public LongSubject longInt(String key) {
        return this.check("getLong(%s)", new Object[]{key}).that(Long.valueOf(this.actual.getLong(key)));
    }

    @NonNull
    public ObjectArraySubject<String> stringArray(@NonNull String key) {
        return this.check("getStringArray(%s)", new Object[]{key}).that((Object[])this.actual.getStringArray(key));
    }

    public StringSubject string(String key) {
        return this.check("getString(%s)", new Object[]{key}).that(this.actual.getString(key));
    }

    public static Subject.Factory<BundleSubject, Bundle> bundles() {
        return BundleSubject$$ExternalSyntheticLambda0.INSTANCE;
    }

    public <T extends Parcelable, SubjectT extends Subject> SubjectT parcelableAsType(String key, Subject.Factory<SubjectT, T> subjectFactory) {
        return (SubjectT)this.check("getParcelable(%s)", new Object[]{key}).about(subjectFactory).that((Object)this.actual.getParcelable(key));
    }

    public Subject serializable(String key) {
        return this.check("getSerializable(%s)", new Object[]{key}).that((Object)this.actual.getSerializable(key));
    }

    BundleSubject(FailureMetadata failureMetadata, Bundle subject) {
        super(failureMetadata, (Object)subject);
        this.actual = subject;
    }

    public void containsKey(String key) {
        if (!this.actual.containsKey(key)) {
            String string = key;
            this.failWithActual(Fact.simpleFact((String)("expected to contain key " + string)), new Fact[0]);
        }
    }

    public void doesNotContainKey(String key) {
        if (this.actual.containsKey(key)) {
            String string = key;
            this.failWithActual(Fact.simpleFact((String)("expected to not contain key " + string)), new Fact[0]);
        }
    }

    public void hasSize(int size) {
        this.check("size()", new Object[0]).that(Integer.valueOf(this.actual.size())).isEqualTo((Object)size);
    }

    public void isEmpty() {
        if (!this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be empty"), new Fact[0]);
        }
    }

    public void isNotEmpty() {
        if (this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be non-empty"), new Fact[0]);
        }
    }
}

