/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.platform.reflect;

import androidx.annotation.RestrictTo;
import androidx.test.internal.platform.reflect.ReflectionException;
import java.lang.reflect.Field;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ReflectiveField<T> {
    private final String className;
    private final String fieldName;
    private boolean initialized = false;
    private Field field;

    public T get(Object object) throws ReflectionException {
        try {
            this.initIfNecessary();
            return (T)this.field.get(object);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    public ReflectiveField(String className, String fieldName) {
        this.className = className;
        this.fieldName = fieldName;
    }

    private synchronized void initIfNecessary() throws ClassNotFoundException, NoSuchFieldException {
        if (this.initialized) {
            return;
        }
        this.field = Class.forName(this.className).getDeclaredField(this.fieldName);
        this.field.setAccessible(true);
        this.initialized = true;
    }
}

