/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.lifecycle;

import android.app.Application;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import androidx.test.runner.lifecycle.ApplicationLifecycleCallback;
import androidx.test.runner.lifecycle.ApplicationLifecycleMonitor;
import androidx.test.runner.lifecycle.ApplicationStage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ApplicationLifecycleMonitorImpl
implements ApplicationLifecycleMonitor {
    private static final String TAG = "ApplicationLifecycleMonitorImpl";
    private final List<WeakReference<ApplicationLifecycleCallback>> callbacks = new ArrayList<WeakReference<ApplicationLifecycleCallback>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleCallback(ApplicationLifecycleCallback callback) {
        Checks.checkNotNull(callback);
        List<WeakReference<ApplicationLifecycleCallback>> list = this.callbacks;
        synchronized (list) {
            boolean needsAdd = true;
            Iterator<WeakReference<ApplicationLifecycleCallback>> refIter = this.callbacks.iterator();
            while (refIter.hasNext()) {
                ApplicationLifecycleCallback storedCallback = (ApplicationLifecycleCallback)refIter.next().get();
                if (null == storedCallback) {
                    refIter.remove();
                    continue;
                }
                if (storedCallback != callback) continue;
                needsAdd = false;
            }
            if (needsAdd) {
                this.callbacks.add(new WeakReference<ApplicationLifecycleCallback>(callback));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleCallback(ApplicationLifecycleCallback callback) {
        Checks.checkNotNull(callback);
        List<WeakReference<ApplicationLifecycleCallback>> list = this.callbacks;
        synchronized (list) {
            Iterator<WeakReference<ApplicationLifecycleCallback>> refIter = this.callbacks.iterator();
            while (refIter.hasNext()) {
                ApplicationLifecycleCallback storedCallback = (ApplicationLifecycleCallback)refIter.next().get();
                if (null == storedCallback) {
                    refIter.remove();
                    continue;
                }
                if (storedCallback != callback) continue;
                refIter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalLifecycleChange(Application app, ApplicationStage stage) {
        List<WeakReference<ApplicationLifecycleCallback>> list = this.callbacks;
        synchronized (list) {
            Iterator<WeakReference<ApplicationLifecycleCallback>> refIter = this.callbacks.iterator();
            while (refIter.hasNext()) {
                ApplicationLifecycleCallback callback = (ApplicationLifecycleCallback)refIter.next().get();
                if (null == callback) {
                    refIter.remove();
                    continue;
                }
                try {
                    String string = String.valueOf(callback);
                    Log.d((String)TAG, (String)new StringBuilder(18 + String.valueOf(string).length()).append("running callback: ").append(string).toString());
                    callback.onApplicationLifecycleChanged(app, stage);
                    string = String.valueOf(callback);
                    Log.d((String)TAG, (String)new StringBuilder(20 + String.valueOf(string).length()).append("callback completes: ").append(string).toString());
                }
                catch (RuntimeException re) {
                    Log.e((String)TAG, (String)String.format("Callback threw exception! (callback: %s stage: %s)", new Object[]{callback, stage}), (Throwable)re);
                }
            }
        }
    }
}

