/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.platform.tracing;

import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.internal.util.Checks;
import androidx.test.platform.tracing.AndroidXTracer;
import androidx.test.platform.tracing.Tracer;
import com.google.errorprone.annotations.MustBeClosed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExperimentalTestApi
public final class Tracing {
    private static final String TAG = Tracing.class.getSimpleName();
    private static final Tracing singleton = new Tracing();
    private final List<Tracer> tracers = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @MustBeClosed
    public Tracer.Span beginSpan(@NonNull String name) {
        HashMap<Tracer, Tracer.Span> spans;
        Checks.checkNotNull(name);
        List<Tracer> list = this.tracers;
        synchronized (list) {
            spans = new HashMap<Tracer, Tracer.Span>(this.tracers.size());
            for (Tracer tracer : this.tracers) {
                spans.put(tracer, Tracing.createUnmanagedSpan(tracer, name));
            }
        }
        return new TracerSpan(spans);
    }

    private static Tracer.Span createUnmanagedChildSpan(Tracer.Span parentSpan, String name) {
        return parentSpan.beginChildSpan(name);
    }

    private static Tracer.Span createUnmanagedSpan(Tracer tracer, String name) {
        return tracer.beginSpan(name);
    }

    @NonNull
    public static Tracing getInstance() {
        return singleton;
    }

    private Tracing() {
        if (Build.VERSION.SDK_INT >= 18) {
            this.registerTracer(new AndroidXTracer());
        }
    }

    public void registerTracer(@NonNull Tracer tracer) {
        Checks.checkNotNull(tracer, "Tracer cannot be null.");
        if (this.tracers.contains(tracer)) {
            String string = String.valueOf(tracer.getClass());
            Log.w((String)TAG, (String)new StringBuilder(24 + String.valueOf(string).length()).append("Tracer already present: ").append(string).toString());
        } else {
            String string = String.valueOf(tracer.getClass());
            Log.i((String)TAG, (String)new StringBuilder(14 + String.valueOf(string).length()).append("Tracer added: ").append(string).toString());
            this.tracers.add(tracer);
        }
    }

    public void unregisterTracer(Tracer tracer) {
        this.tracers.remove(tracer);
        String string = String.valueOf(tracer == null ? null : tracer.getClass());
        Log.i((String)TAG, (String)new StringBuilder(16 + String.valueOf(string).length()).append("Tracer removed: ").append(string).toString());
    }

    class TracerSpan
    implements Tracer.Span {
        private final Map<Tracer, Tracer.Span> spans;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        public Tracer.Span beginChildSpan(@NonNull String name) {
            HashMap<Tracer, Tracer.Span> childSpans;
            Checks.checkNotNull(name);
            List list = Tracing.this.tracers;
            synchronized (list) {
                childSpans = new HashMap<Tracer, Tracer.Span>(Tracing.this.tracers.size());
                for (Tracer tracer : Tracing.this.tracers) {
                    Tracer.Span parentSpan = this.spans.get(tracer);
                    if (parentSpan == null) continue;
                    childSpans.put(tracer, Tracing.createUnmanagedChildSpan(parentSpan, name));
                }
            }
            return new TracerSpan(childSpans);
        }

        private TracerSpan(Map<Tracer, Tracer.Span> spans) {
            this.spans = spans;
        }

        @Override
        public void close() {
            for (Tracer.Span span : this.spans.values()) {
                span.close();
            }
        }
    }
}

