/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.platform.io;

import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import androidx.test.internal.util.Checks;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.platform.io.PlatformTestStorageRegistry$$ExternalSyntheticLambda0;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@ExperimentalTestApi
public final class PlatformTestStorageRegistry {
    private static PlatformTestStorage testStorageInstance = ServiceLoaderWrapper.loadSingleService(PlatformTestStorage.class, PlatformTestStorageRegistry$$ExternalSyntheticLambda0.INSTANCE);

    public static synchronized PlatformTestStorage getInstance() {
        return testStorageInstance;
    }

    private PlatformTestStorageRegistry() {
    }

    public static synchronized void registerInstance(PlatformTestStorage instance) {
        testStorageInstance = Checks.checkNotNull(instance);
    }

    static class NoOpPlatformTestStorage
    implements PlatformTestStorage {
        @Override
        public InputStream openInputFile(String pathname) {
            return new NullInputStream();
        }

        @Override
        public InputStream openInternalInputFile(String pathname) throws IOException {
            return new NullInputStream();
        }

        @Override
        public OutputStream openInternalOutputFile(String pathname) throws IOException {
            return new NullOutputStream();
        }

        @Override
        public OutputStream openOutputFile(String pathname) {
            return new NullOutputStream();
        }

        @Override
        public OutputStream openOutputFile(String pathname, boolean append) {
            return new NullOutputStream();
        }

        @Override
        public String getInputArg(String argName) {
            return null;
        }

        @Override
        public Map<String, String> getInputArgs() {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, Serializable> getOutputProperties() {
            return new HashMap<String, Serializable>();
        }

        NoOpPlatformTestStorage() {
        }

        @Override
        public void addOutputProperties(Map<String, Serializable> properties) {
        }

        static class NullInputStream
        extends InputStream {
            @Override
            public int read() {
                return -1;
            }

            NullInputStream() {
            }
        }

        static class NullOutputStream
        extends OutputStream {
            NullOutputStream() {
            }

            @Override
            public void write(int b) {
            }
        }
    }
}

