/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.test.runner.lifecycle;

import android.app.Application;

/** Callback for monitoring application lifecycle events. */
public interface ApplicationLifecycleCallback {

  /**
   * Called on after an application has processed its lifecycle change event (for example onCreate)
   * These callbacks may occur on main thread so implementers should limit the amount of processing
   * performed
   *
   * @param app the {@link Application}
   * @param stage its current stage.
   */
  public void onApplicationLifecycleChanged(Application app, ApplicationStage stage);
}
