/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.intent;

import android.content.Intent;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.runner.intent.IntentCallback;
import androidx.test.runner.intent.IntentMonitor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class IntentMonitorImpl
implements IntentMonitor {
    private static final String TAG = "IntentMonitorImpl";
    private final List<WeakReference<IntentCallback>> callbacks = new ArrayList<WeakReference<IntentCallback>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIntentCallback(@NonNull IntentCallback callback) {
        if (null == callback) {
            throw new NullPointerException("callback cannot be null!");
        }
        boolean needsAdd = true;
        List<WeakReference<IntentCallback>> list = this.callbacks;
        synchronized (list) {
            Iterator<WeakReference<IntentCallback>> refIter = this.callbacks.iterator();
            while (refIter.hasNext()) {
                IntentCallback storedCallback = (IntentCallback)refIter.next().get();
                if (null == storedCallback) {
                    refIter.remove();
                    continue;
                }
                if (storedCallback != callback) continue;
                needsAdd = false;
            }
            if (needsAdd) {
                this.callbacks.add(new WeakReference<IntentCallback>(callback));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIntentCallback(@NonNull IntentCallback callback) {
        if (null == callback) {
            throw new NullPointerException("callback cannot be null!");
        }
        List<WeakReference<IntentCallback>> list = this.callbacks;
        synchronized (list) {
            Iterator<WeakReference<IntentCallback>> refIter = this.callbacks.iterator();
            while (refIter.hasNext()) {
                IntentCallback storedCallback = (IntentCallback)refIter.next().get();
                if (null == storedCallback) {
                    refIter.remove();
                    continue;
                }
                if (storedCallback != callback) continue;
                refIter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalIntent(Intent intent) {
        List<WeakReference<IntentCallback>> list = this.callbacks;
        synchronized (list) {
            Iterator<WeakReference<IntentCallback>> refIter = this.callbacks.iterator();
            while (refIter.hasNext()) {
                IntentCallback callback = (IntentCallback)refIter.next().get();
                if (null == callback) {
                    refIter.remove();
                    continue;
                }
                try {
                    callback.onIntentSent(new Intent(intent));
                }
                catch (RuntimeException e) {
                    Log.e((String)TAG, (String)String.format("Callback threw exception! (callback: %s intent: %s)", callback, intent), (Throwable)e);
                }
            }
        }
    }
}

