/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.util;

import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.ProcSummary;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class LogUtil {
    private static volatile String myProcName = null;

    public static void logDebug(String tag, String message, Object ... args) {
        LogUtil.logDebug(tag, () -> message, args);
    }

    private static void logDebug(String tag, Supplier msgSupplier, Object ... args) {
        if (LogUtil.isLoggable(tag, 3)) {
            Object[] convertedArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                convertedArgs[i] = args[i] instanceof Supplier ? ((Supplier)args[i]).get() : args[i];
            }
            Log.d((String)tag, (String)String.format(msgSupplier.get(), convertedArgs));
        }
    }

    public static void logDebugWithProcess(String tag, String message, Object ... args) {
        LogUtil.logDebug(tag, () -> message + " in " + LogUtil.procName(), args);
    }

    private static final String procName() {
        String procDesc = myProcName;
        if (procDesc == null) {
            try {
                procDesc = ProcSummary.summarize((String)"self").cmdline;
            }
            catch (ProcSummary.SummaryException se) {
                procDesc = "unknown";
            }
            if (procDesc.length() > 64 && procDesc.contains("-classpath")) {
                procDesc = "robolectric";
            }
        }
        return procDesc;
    }

    private static boolean isLoggable(String tag, int level) {
        if (tag.length() > 23) {
            tag = tag.substring(0, 22);
        }
        return Log.isLoggable((String)tag, (int)level);
    }

    public static Supplier lazyArg(Supplier supplier) {
        return supplier;
    }

    public static interface Supplier {
        public String get();
    }
}

