/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.platform.graphics;

import android.os.Build;
import android.util.Log;
import androidx.test.internal.platform.reflect.ReflectionException;
import androidx.test.internal.platform.reflect.ReflectiveMethod;

public class HardwareRendererCompat {
    private static final String TAG = "HardwareRendererCompat";
    private static final ReflectiveMethod<Boolean> isDrawingEnabledReflectiveCall = new ReflectiveMethod("android.graphics.HardwareRenderer", "isDrawingEnabled", new Class[0]);
    private static final ReflectiveMethod<Void> setDrawingEnabledReflectiveCall = new ReflectiveMethod("android.graphics.HardwareRenderer", "setDrawingEnabled", Boolean.TYPE);

    private HardwareRendererCompat() {
    }

    public static boolean isDrawingEnabled() {
        if (Build.VERSION.SDK_INT < 30) {
            return true;
        }
        try {
            return isDrawingEnabledReflectiveCall.invokeStatic(new Object[0]);
        }
        catch (ReflectionException e) {
            Log.d((String)TAG, (String)"Failed to reflectively call HardwareRenderer#isDrawingEnabled. It probably doesn't exist on this platform. Returning true.");
            return true;
        }
    }

    public static void setDrawingEnabled(boolean renderingEnabled) {
        if (Build.VERSION.SDK_INT < 30) {
            return;
        }
        try {
            setDrawingEnabledReflectiveCall.invokeStatic(renderingEnabled);
        }
        catch (ReflectionException e) {
            Log.i((String)TAG, (String)"Failed to reflectively call HardwareRenderer#setDrawingEnabled.  It probably doesn't exist on this platform. Ignoring.");
        }
    }
}

