/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule.provider;

import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.test.mock.MockContentResolver;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.rule.provider.DatabaseArgs;
import androidx.test.rule.provider.DelegatingContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@ExperimentalTestApi
public class ProviderTestRule
implements TestRule {
    private static final String TAG = "ProviderTestRule";
    private final Set<WeakReference<ContentProvider>> providersRef;
    private final Set<DatabaseArgs> databaseArgsSet;
    private final ContentResolver resolver;
    private final DelegatingContext context;

    @VisibleForTesting
    ProviderTestRule(Set<WeakReference<ContentProvider>> providersRef, Set<DatabaseArgs> databaseArgsSet, ContentResolver resolver, DelegatingContext context) {
        this.providersRef = providersRef;
        this.databaseArgsSet = databaseArgsSet;
        this.resolver = resolver;
        this.context = context;
    }

    public ContentResolver getResolver() {
        return this.resolver;
    }

    public Statement apply(Statement base, Description description) {
        return new ProviderStatement(base);
    }

    public void runDatabaseCommands(@NonNull String dbName, String ... dbCmds) {
        Checks.checkNotNull((Object)dbName);
        Checks.checkNotNull((Object)dbCmds);
        if (dbCmds.length > 0) {
            SQLiteDatabase database = this.context.openOrCreateDatabase(dbName, 0, null);
            for (String cmd : dbCmds) {
                if (TextUtils.isEmpty((CharSequence)cmd)) continue;
                try {
                    database.execSQL(cmd);
                }
                catch (SQLiteException e) {
                    Log.e((String)TAG, (String)String.format("Error executing sql command %s, possibly wrong or duplicated commands (e.g. same table insertion command without checking current table existence).", cmd));
                    throw e;
                }
            }
        }
    }

    public void revokePermission(@NonNull String permission) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)permission) ? 1 : 0) != 0, (Object)"permission cannot be null or empty");
        this.context.addRevokedPermission(permission);
    }

    protected void beforeProviderSetup() {
    }

    protected void afterProviderCleanedUp() {
    }

    private void setUpProviders() throws IOException {
        this.beforeProviderSetup();
        for (DatabaseArgs databaseArgs : this.databaseArgsSet) {
            this.setUpProvider(databaseArgs);
        }
    }

    private void setUpProvider(DatabaseArgs databaseArgs) throws IOException {
        if (databaseArgs.hasDBDataFile()) {
            this.restoreDBDataFromFile(databaseArgs);
        }
        if (databaseArgs.hasDBCmdFile()) {
            this.collectDBCmdsFromFile(databaseArgs);
        }
        if (databaseArgs.hasDBCmds()) {
            this.runDatabaseCommands(databaseArgs.getDBName(), databaseArgs.getDBCmds());
        }
    }

    private void restoreDBDataFromFile(DatabaseArgs databaseArgs) throws IOException {
        File dbDataFile = databaseArgs.getDBDataFile();
        Checks.checkState((boolean)dbDataFile.exists(), (Object)String.format("The database file %s doesn't exist!", dbDataFile));
        String dbName = databaseArgs.getDBName();
        this.copyFile(dbDataFile, this.context.getDatabasePath(dbName));
        this.context.addDatabase(dbName);
    }

    private void collectDBCmdsFromFile(DatabaseArgs databaseArgs) throws IOException {
        BufferedReader br = null;
        File dbCmdFile = databaseArgs.getDBCmdFile();
        ArrayList<String> cmdsToAdd = new ArrayList<String>();
        try {
            String currentLine;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dbCmdFile), Charset.forName("UTF-8")));
            while ((currentLine = br.readLine()) != null) {
                if (TextUtils.isEmpty((CharSequence)currentLine)) continue;
                cmdsToAdd.add(currentLine);
            }
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)String.format("Cannot open command file %s to read", dbCmdFile));
            throw ioe;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        databaseArgs.addDBCmds(cmdsToAdd.toArray(new String[cmdsToAdd.size()]));
    }

    private void copyFile(File src, File dest) throws IOException {
        File destParent = dest.getParentFile();
        if (!destParent.exists() && !destParent.mkdirs()) {
            String errorMessage = String.format("error happened creating parent dir for file %s", dest);
            Log.e((String)TAG, (String)errorMessage);
            throw new IOException(errorMessage);
        }
        FileChannel in = new FileInputStream(src).getChannel();
        FileChannel out = new FileOutputStream(dest).getChannel();
        try {
            in.transferTo(0L, in.size(), out);
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)String.format("error happened copying file from %s to %s", src, dest));
            throw ioe;
        }
        finally {
            in.close();
            out.close();
        }
    }

    private void cleanUpProviders() {
        if (Build.VERSION.SDK_INT >= 11) {
            for (WeakReference weakReference : this.providersRef) {
                ContentProvider provider = (ContentProvider)weakReference.get();
                if (provider == null) continue;
                provider.shutdown();
            }
        }
        for (DatabaseArgs databaseArgs : this.databaseArgsSet) {
            String dbName = databaseArgs.getDBName();
            if (dbName == null) continue;
            this.context.deleteDatabase(dbName);
        }
        this.afterProviderCleanedUp();
    }

    private class ProviderStatement
    extends Statement {
        private final Statement base;

        public ProviderStatement(Statement base) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            try {
                ProviderTestRule.this.setUpProviders();
                this.base.evaluate();
            }
            finally {
                ProviderTestRule.this.cleanUpProviders();
            }
        }
    }

    public static class Builder {
        private static final String DEFAULT_PREFIX = "test.";
        private final Map<String, Class<? extends ContentProvider>> providerClasses = new HashMap<String, Class<? extends ContentProvider>>();
        private final Map<String, DatabaseArgs> databaseArgsMap = new HashMap<String, DatabaseArgs>();
        private String prefix = "test.";

        public <T extends ContentProvider> Builder(@NonNull Class<T> providerClass, @NonNull String providerAuth) {
            Checks.checkNotNull(providerClass);
            Checks.checkNotNull((Object)providerAuth);
            this.providerClasses.put(providerAuth, providerClass);
        }

        public Builder setPrefix(@NonNull String prefix) {
            Checks.checkArgument((!TextUtils.isEmpty((CharSequence)prefix) ? 1 : 0) != 0, (Object)"The prefix cannot be null or empty");
            this.prefix = prefix;
            return this;
        }

        public Builder setDatabaseFile(@NonNull String dbName, @NonNull File dbDataFile) {
            Checks.checkNotNull((Object)dbName);
            Checks.checkNotNull((Object)dbDataFile);
            this.getDatabaseArgs(dbName).setDBDataFile(dbDataFile);
            return this;
        }

        public Builder setDatabaseCommands(@NonNull String dbName, String ... dbCmds) {
            Checks.checkNotNull((Object)dbName);
            Checks.checkNotNull((Object)dbCmds);
            this.getDatabaseArgs(dbName).setDBCmds(dbCmds);
            return this;
        }

        public Builder setDatabaseCommandsFile(@NonNull String dbName, @NonNull File dbCmdFile) {
            Checks.checkNotNull((Object)dbName);
            Checks.checkNotNull((Object)dbCmdFile);
            this.getDatabaseArgs(dbName).setDBCmdFile(dbCmdFile);
            return this;
        }

        public <T extends ContentProvider> Builder addProvider(@NonNull Class<T> providerClass, @NonNull String providerAuth) {
            Checks.checkNotNull(providerClass);
            Checks.checkNotNull((Object)providerAuth);
            Checks.checkState((this.providerClasses.size() > 0 ? 1 : 0) != 0, (Object)"No existing provider yet while trying to add more");
            Checks.checkState((!this.providerClasses.containsKey(providerAuth) ? 1 : 0) != 0, (Object)String.format("ContentProvider with authority %s already exists.", providerAuth));
            this.providerClasses.put(providerAuth, providerClass);
            return this;
        }

        public ProviderTestRule build() {
            HashSet<WeakReference<ContentProvider>> mProvidersRef = new HashSet<WeakReference<ContentProvider>>();
            MockContentResolver resolver = new MockContentResolver();
            DelegatingContext context = new DelegatingContext(InstrumentationRegistry.getInstrumentation().getTargetContext(), this.prefix, (ContentResolver)resolver);
            for (Map.Entry<String, Class<? extends ContentProvider>> entry : this.providerClasses.entrySet()) {
                ContentProvider provider = this.createProvider(entry.getKey(), entry.getValue(), resolver, (Context)context);
                mProvidersRef.add(new WeakReference<ContentProvider>(provider));
            }
            return new ProviderTestRule(mProvidersRef, new HashSet<DatabaseArgs>(this.databaseArgsMap.values()), (ContentResolver)resolver, context);
        }

        private ContentProvider createProvider(String auth, Class<? extends ContentProvider> clazz, MockContentResolver resolver, Context context) {
            ContentProvider provider;
            try {
                provider = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException me) {
                String string = String.valueOf(clazz.toString());
                Log.e((String)ProviderTestRule.TAG, (String)(string.length() != 0 ? "NoSuchMethodException occurred when trying create new Instance for ".concat(string) : new String("NoSuchMethodException occurred when trying create new Instance for ")));
                throw new RuntimeException(me);
            }
            catch (InvocationTargetException ite) {
                String string = String.valueOf(clazz.toString());
                Log.e((String)ProviderTestRule.TAG, (String)(string.length() != 0 ? "InvocationTargetException occurred when trying create new Instance for ".concat(string) : new String("InvocationTargetException occurred when trying create new Instance for ")));
                throw new RuntimeException(ite);
            }
            catch (IllegalAccessException iae) {
                String string = String.valueOf(clazz.toString());
                Log.e((String)ProviderTestRule.TAG, (String)(string.length() != 0 ? "IllegalAccessException occurred when trying create new Instance for ".concat(string) : new String("IllegalAccessException occurred when trying create new Instance for ")));
                throw new RuntimeException(iae);
            }
            catch (InstantiationException ie) {
                String string = String.valueOf(clazz.toString());
                Log.e((String)ProviderTestRule.TAG, (String)(string.length() != 0 ? "InstantiationException occurred when trying create new Instance for ".concat(string) : new String("InstantiationException occurred when trying create new Instance for ")));
                throw new RuntimeException(ie);
            }
            ProviderInfo providerInfo = new ProviderInfo();
            providerInfo.authority = auth;
            provider.attachInfo(context, providerInfo);
            resolver.addProvider(providerInfo.authority, provider);
            return provider;
        }

        private DatabaseArgs getDatabaseArgs(String dbName) {
            if (this.databaseArgsMap.containsKey(dbName)) {
                return this.databaseArgsMap.get(dbName);
            }
            DatabaseArgs databaseArgs = new DatabaseArgs(dbName);
            this.databaseArgsMap.put(dbName, databaseArgs);
            return databaseArgs;
        }
    }
}

