/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.util.Checks;
import java.util.Properties;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PortForwardingRule
implements TestRule {
    private static final String TAG = "PortForwardingRule";
    public static final int MIN_PORT = 1024;
    public static final int MAX_PORT = 65535;
    @VisibleForTesting
    static final int DEFAULT_PROXY_PORT = 8080;
    @VisibleForTesting
    static final String DEFAULT_PROXY_HOST = "127.0.0.1";
    @VisibleForTesting
    static final String HTTP_HOST_PROPERTY = "http.proxyHost";
    @VisibleForTesting
    static final String HTTPS_HOST_PROPERTY = "https.proxyHost";
    @VisibleForTesting
    static final String HTTP_PORT_PROPERTY = "http.proxyPort";
    @VisibleForTesting
    static final String HTTPS_PORT_PROPERTY = "https.proxyPort";
    @VisibleForTesting
    final String proxyHost;
    @VisibleForTesting
    final int proxyPort;
    @VisibleForTesting
    Properties prop;
    private Properties backUpProp;

    private PortForwardingRule(Builder builder) {
        this(builder.proxyHost, builder.proxyPort, builder.prop);
    }

    protected PortForwardingRule(int proxyPort) {
        this(DEFAULT_PROXY_HOST, proxyPort, System.getProperties());
    }

    @VisibleForTesting
    PortForwardingRule(String proxyHost, int proxyPort, @NonNull Properties properties) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.prop = (Properties)Checks.checkNotNull((Object)properties);
        this.backUpProp = new Properties();
        this.backUpProperties();
    }

    protected static int getDefaultPort() {
        return 8080;
    }

    protected void beforePortForwarding() {
    }

    protected void afterPortForwarding() {
    }

    protected void beforeRestoreForwarding() {
    }

    protected void afterRestoreForwarding() {
    }

    private void setPortForwarding() {
        this.beforePortForwarding();
        this.prop.setProperty(HTTP_HOST_PROPERTY, this.proxyHost);
        this.prop.setProperty(HTTPS_HOST_PROPERTY, this.proxyHost);
        this.prop.setProperty(HTTP_PORT_PROPERTY, String.valueOf(this.proxyPort));
        this.prop.setProperty(HTTPS_PORT_PROPERTY, String.valueOf(this.proxyPort));
        this.afterPortForwarding();
    }

    private void restorePortForwarding() {
        try {
            this.beforeRestoreForwarding();
        }
        finally {
            this.restoreOneProperty(this.prop, this.backUpProp, HTTP_HOST_PROPERTY);
            this.restoreOneProperty(this.prop, this.backUpProp, HTTPS_HOST_PROPERTY);
            this.restoreOneProperty(this.prop, this.backUpProp, HTTP_PORT_PROPERTY);
            this.restoreOneProperty(this.prop, this.backUpProp, HTTPS_PORT_PROPERTY);
            this.afterRestoreForwarding();
        }
    }

    private void backUpProperties() {
        if (this.prop.getProperty(HTTP_HOST_PROPERTY) != null) {
            this.backUpProp.setProperty(HTTP_HOST_PROPERTY, this.prop.getProperty(HTTP_HOST_PROPERTY));
        }
        if (this.prop.getProperty(HTTPS_HOST_PROPERTY) != null) {
            this.backUpProp.setProperty(HTTPS_HOST_PROPERTY, this.prop.getProperty(HTTPS_HOST_PROPERTY));
        }
        if (this.prop.getProperty(HTTP_PORT_PROPERTY) != null) {
            this.backUpProp.setProperty(HTTP_PORT_PROPERTY, this.prop.getProperty(HTTP_PORT_PROPERTY));
        }
        if (this.prop.getProperty(HTTPS_PORT_PROPERTY) != null) {
            this.backUpProp.setProperty(HTTPS_PORT_PROPERTY, this.prop.getProperty(HTTPS_PORT_PROPERTY));
        }
    }

    private void restoreOneProperty(Properties prop, Properties backUpProp, String key) {
        if (backUpProp.getProperty(key) != null) {
            prop.setProperty(key, backUpProp.getProperty(key));
        } else {
            prop.remove(key);
        }
    }

    public Statement apply(Statement base, Description description) {
        return new PortForwardingStatement(base);
    }

    private class PortForwardingStatement
    extends Statement {
        private final Statement base;

        public PortForwardingStatement(Statement base) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            try {
                PortForwardingRule.this.setPortForwarding();
                Log.i((String)PortForwardingRule.TAG, (String)String.format("The current process traffic is forwarded to %s:%d", PortForwardingRule.this.proxyHost, PortForwardingRule.this.proxyPort));
                this.base.evaluate();
            }
            finally {
                PortForwardingRule.this.restorePortForwarding();
                Log.i((String)PortForwardingRule.TAG, (String)"Current process traffic forwarding is cancelled");
            }
        }
    }

    public static class Builder {
        private String proxyHost = "127.0.0.1";
        private int proxyPort = 8080;
        private Properties prop = System.getProperties();

        public Builder withProxyHost(@NonNull String proxyHost) {
            this.proxyHost = (String)Checks.checkNotNull((Object)proxyHost);
            return this;
        }

        public Builder withProxyPort(int proxyPort) {
            Checks.checkArgument((proxyPort >= 1024 && proxyPort <= 65535 ? 1 : 0) != 0, (String)"%d is used as a proxy port, must in range [%d, %d]", (Object[])new Object[]{proxyPort, 1024, 65535});
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder withProperties(@NonNull Properties properties) {
            this.prop = (Properties)Checks.checkNotNull((Object)properties);
            return this;
        }

        public PortForwardingRule build() {
            return new PortForwardingRule(this);
        }
    }
}

