/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit4.statement;

import androidx.test.internal.runner.junit4.statement.UiThreadStatement;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class RunAfters
extends UiThreadStatement {
    private final Statement mNext;
    private final Object mTarget;
    private final List<FrameworkMethod> mAfters;

    public RunAfters(FrameworkMethod method, Statement next, List<FrameworkMethod> afters, Object target) {
        super(next, RunAfters.shouldRunOnUiThread(method));
        this.mNext = next;
        this.mAfters = afters;
        this.mTarget = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate() throws Throwable {
        CopyOnWriteArrayList<Throwable> errors = new CopyOnWriteArrayList<Throwable>();
        try {
            this.mNext.evaluate();
        }
        catch (Throwable e) {
            try {
                errors.add(e);
            }
            catch (Throwable throwable) {
                for (FrameworkMethod each : this.mAfters) {
                    if (RunAfters.shouldRunOnUiThread(each)) {
                        RunAfters.runOnUiThread(new Runnable(each, errors){
                            final /* synthetic */ FrameworkMethod val$each;
                            final /* synthetic */ List val$errors;
                            {
                                this.val$each = frameworkMethod;
                                this.val$errors = list;
                            }

                            @Override
                            public void run() {
                                try {
                                    this.val$each.invokeExplosively(RunAfters.this.mTarget, new Object[0]);
                                }
                                catch (Throwable throwable) {
                                    this.val$errors.add(throwable);
                                }
                            }
                        });
                        continue;
                    }
                    try {
                        each.invokeExplosively(this.mTarget, new Object[0]);
                    }
                    catch (Throwable e2) {
                        errors.add(e2);
                    }
                }
                throw throwable;
            }
            for (FrameworkMethod each : this.mAfters) {
                if (RunAfters.shouldRunOnUiThread(each)) {
                    RunAfters.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
                    continue;
                }
                try {
                    each.invokeExplosively(this.mTarget, new Object[0]);
                }
                catch (Throwable e3) {
                    errors.add(e3);
                }
            }
        }
        for (FrameworkMethod each : this.mAfters) {
            if (RunAfters.shouldRunOnUiThread(each)) {
                RunAfters.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
                continue;
            }
            try {
                each.invokeExplosively(this.mTarget, new Object[0]);
            }
            catch (Throwable e) {
                errors.add(e);
            }
        }
        MultipleFailureException.assertEmpty(errors);
    }
}

