/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit4;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.util.AndroidRunnerParams;
import androidx.test.runner.AndroidJUnit4;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

public class AndroidAnnotatedBuilder
extends AnnotatedBuilder {
    private static final String LOG_TAG = "AndroidAnnotatedBuilder";
    private final AndroidRunnerParams androidRunnerParams;

    public AndroidAnnotatedBuilder(RunnerBuilder suiteBuilder, AndroidRunnerParams runnerParams) {
        super(suiteBuilder);
        this.androidRunnerParams = runnerParams;
    }

    public Runner runnerForClass(Class<?> testClass) throws Exception {
        block5: {
            try {
                RunWith annotation = testClass.getAnnotation(RunWith.class);
                if (annotation == null || !AndroidJUnit4.class.equals((Object)annotation.value())) break block5;
                Class runnerClass = annotation.value();
                try {
                    Runner runner = this.buildAndroidRunner(runnerClass, testClass);
                    if (runner != null) {
                        return runner;
                    }
                }
                catch (NoSuchMethodException e) {
                    return super.buildRunner(runnerClass, testClass);
                }
            }
            catch (Throwable e) {
                Log.e((String)LOG_TAG, (String)"Error constructing runner", (Throwable)e);
                throw e;
            }
        }
        return super.runnerForClass(testClass);
    }

    @VisibleForTesting
    public Runner buildAndroidRunner(Class<? extends Runner> runnerClass, Class<?> testClass) throws Exception {
        return runnerClass.getConstructor(Class.class, AndroidRunnerParams.class).newInstance(testClass, this.androidRunnerParams);
    }
}

