/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.run;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.FailureInfo;
import androidx.test.services.events.run.TestRunEvent;
import java.util.ArrayList;
import java.util.List;

public class TestRunFinishedEvent
extends TestRunEvent {
    public final int count;
    public final int ignoreCount;
    public final long runTime;
    @NonNull
    public final List<FailureInfo> failures;

    public TestRunFinishedEvent(int count, int ignoreCount, long runTime, @NonNull List<FailureInfo> failures) {
        Checks.checkNotNull(failures, (Object)"failures cannot be null");
        this.count = count;
        this.ignoreCount = ignoreCount;
        this.runTime = runTime;
        this.failures = failures;
    }

    TestRunFinishedEvent(Parcel source) {
        Parcelable[] failures;
        this.count = source.readInt();
        this.ignoreCount = source.readInt();
        this.runTime = source.readLong();
        this.failures = new ArrayList<FailureInfo>();
        for (Parcelable failure : failures = source.readParcelableArray(FailureInfo[].class.getClassLoader())) {
            this.failures.add((FailureInfo)failure);
        }
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.count);
        parcel.writeInt(this.ignoreCount);
        parcel.writeLong(this.runTime);
        parcel.writeParcelableArray((Parcelable[])this.failures.toArray(new FailureInfo[0]), i);
    }

    @Override
    TestRunEvent.EventType instanceType() {
        return TestRunEvent.EventType.FINISHED;
    }
}

