/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.coverage;

import android.app.Instrumentation;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.runner.internal.deps.desugar.ThrowableExtension;
import androidx.test.services.storage.TestStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class InstrumentationCoverageReporter {
    private static final String TAG = InstrumentationCoverageReporter.class.getSimpleName();
    private static final String EMMA_RUNTIME_CLASS = "com.vladium.emma.rt.RT";
    private static final String DEFAULT_COVERAGE_FILE_NAME = "coverage.ec";
    private final Instrumentation instrumentation;
    private final PlatformTestStorage testStorage;

    public InstrumentationCoverageReporter(Instrumentation instrumentation, PlatformTestStorage testStorage) {
        this.instrumentation = instrumentation;
        this.testStorage = testStorage;
    }

    public String generateCoverageReport(@Nullable String coverageFilePath, PrintStream instrumentationResultWriter) {
        coverageFilePath = this.testStorage instanceof TestStorage ? this.dumpCoverageToTestStorage(coverageFilePath, instrumentationResultWriter) : this.dumpCoverageToFile(coverageFilePath, instrumentationResultWriter);
        String string = String.valueOf(coverageFilePath);
        Log.d((String)TAG, (String)(string.length() != 0 ? "Coverage file was generated to ".concat(string) : new String("Coverage file was generated to ")));
        instrumentationResultWriter.format("\nGenerated code coverage data to %s", coverageFilePath);
        return coverageFilePath;
    }

    private String dumpCoverageToFile(String coverageFilePath, PrintStream instrumentationResultWriter) {
        if (coverageFilePath == null) {
            Log.d((String)TAG, (String)"No coverage file path was specified. Dumps to the default file path.");
            String string = this.instrumentation.getTargetContext().getFilesDir().getAbsolutePath();
            String string2 = File.separator;
            coverageFilePath = new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append(DEFAULT_COVERAGE_FILE_NAME).toString();
        }
        if (!this.generateCoverageInternal(coverageFilePath, instrumentationResultWriter)) {
            Log.w((String)TAG, (String)"Failed to generate the coverage data file. Please refer to the instrumentation result for more info.");
        }
        return coverageFilePath;
    }

    private String dumpCoverageToTestStorage(String coverageFilePath, PrintStream instrumentationResultWriter) {
        if (coverageFilePath == null) {
            Log.d((String)TAG, (String)"No coverage file path was specified. Dumps to the default coverage file using test storage.");
            coverageFilePath = DEFAULT_COVERAGE_FILE_NAME;
        }
        String string = this.instrumentation.getTargetContext().getFilesDir().getAbsolutePath();
        String string2 = File.separator;
        String tempCoverageFilePath = new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append(DEFAULT_COVERAGE_FILE_NAME).toString();
        if (!this.generateCoverageInternal(tempCoverageFilePath, instrumentationResultWriter)) {
            Log.w((String)TAG, (String)"Failed to generate the coverage data file. Please refer to the instrumentation result for more info.");
        }
        try {
            Log.d((String)TAG, (String)"Test service is available. Moving the coverage data file to be managed by the storage service.");
            this.moveFileToTestStorage(tempCoverageFilePath, coverageFilePath);
            return coverageFilePath;
        }
        catch (IOException e) {
            this.reportEmmaError(instrumentationResultWriter, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void moveFileToTestStorage(String srcFilePath, String destFilePath) throws IOException {
        File srcFile;
        block14: {
            srcFile = new File(srcFilePath);
            if (!srcFile.exists()) return;
            Log.d((String)TAG, (String)String.format("Moving coverage file [%s] to the internal test storage [%s].", srcFilePath, destFilePath));
            OutputStream outputStream = this.testStorage.openInternalOutputFile(destFilePath);
            try {
                block13: {
                    FileChannel srcChannel = new FileInputStream(srcFilePath).getChannel();
                    try {
                        block12: {
                            WritableByteChannel destChannel = Channels.newChannel(outputStream);
                            try {
                                srcChannel.transferTo(0L, srcChannel.size(), destChannel);
                                if (destChannel == null) break block12;
                            }
                            catch (Throwable throwable) {
                                if (destChannel == null) throw throwable;
                                try {
                                    destChannel.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    ThrowableExtension.addSuppressed(throwable, throwable2);
                                }
                                throw throwable;
                            }
                            destChannel.close();
                        }
                        if (srcChannel == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (srcChannel == null) throw throwable;
                        try {
                            srcChannel.close();
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            ThrowableExtension.addSuppressed(throwable, throwable3);
                        }
                        throw throwable;
                    }
                    srcChannel.close();
                }
                if (outputStream == null) break block14;
            }
            catch (Throwable throwable) {
                if (outputStream == null) throw throwable;
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable4) {
                    ThrowableExtension.addSuppressed(throwable, throwable4);
                }
                throw throwable;
            }
            outputStream.close();
        }
        if (srcFile.delete()) return;
        Log.e((String)TAG, (String)String.format("Failed to delete original coverage file [%s]", srcFile.getAbsolutePath()));
    }

    @VisibleForTesting
    public boolean generateCoverageInternal(String coverageFilePath, PrintStream instrumentationResultWriter) {
        File coverageFile = new File(coverageFilePath);
        try {
            Class<?> emmaRTClass;
            try {
                emmaRTClass = Class.forName(EMMA_RUNTIME_CLASS, true, this.instrumentation.getTargetContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                emmaRTClass = Class.forName(EMMA_RUNTIME_CLASS, true, this.instrumentation.getContext().getClassLoader());
                String msg = "Generating coverage for alternate test context.";
                Log.w((String)TAG, (String)msg);
                instrumentationResultWriter.format("\nWarning: %s", msg);
            }
            Method dumpCoverageMethod = emmaRTClass.getMethod("dumpCoverageData", coverageFile.getClass(), Boolean.TYPE, Boolean.TYPE);
            dumpCoverageMethod.invoke(null, coverageFile, false, false);
            return true;
        }
        catch (ClassNotFoundException e) {
            this.reportEmmaError(instrumentationResultWriter, "Is Emma/JaCoCo jar on classpath?", e);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.reportEmmaError(instrumentationResultWriter, e);
        }
        return false;
    }

    private void reportEmmaError(PrintStream writer, Exception e) {
        this.reportEmmaError(writer, "", e);
    }

    private void reportEmmaError(PrintStream writer, String hint, Exception e) {
        String string = String.valueOf(hint);
        String msg = string.length() != 0 ? "Failed to generate Emma/JaCoCo coverage. ".concat(string) : new String("Failed to generate Emma/JaCoCo coverage. ");
        Log.e((String)TAG, (String)msg, (Throwable)e);
        writer.format("\nError: %s", msg);
    }
}

