/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.runner.listener.InstrumentationRunListener;
import androidx.test.services.events.internal.StackTrimmer;
import java.io.PrintStream;
import org.junit.internal.TextListener;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class InstrumentationResultPrinter
extends InstrumentationRunListener {
    private static final String TAG = "InstrumentationResultPrinter";
    public static final String REPORT_VALUE_ID = "AndroidJUnitRunner";
    public static final String REPORT_KEY_NUM_TOTAL = "numtests";
    public static final String REPORT_KEY_NUM_CURRENT = "current";
    public static final String REPORT_KEY_NAME_CLASS = "class";
    public static final String REPORT_KEY_NAME_TEST = "test";
    public static final int REPORT_VALUE_RESULT_START = 1;
    public static final int REPORT_VALUE_RESULT_OK = 0;
    @Deprecated
    public static final int REPORT_VALUE_RESULT_ERROR = -1;
    public static final int REPORT_VALUE_RESULT_FAILURE = -2;
    public static final int REPORT_VALUE_RESULT_IGNORED = -3;
    public static final int REPORT_VALUE_RESULT_ASSUMPTION_FAILURE = -4;
    public static final String REPORT_KEY_STACK = "stack";
    private final Bundle resultTemplate;
    @VisibleForTesting
    Bundle testResult;
    int testNum = 0;
    int testResultCode = -999;
    String testClass = null;
    private Description description = Description.EMPTY;

    public InstrumentationResultPrinter() {
        this.resultTemplate = new Bundle();
        this.testResult = new Bundle(this.resultTemplate);
    }

    public void testRunStarted(Description description) throws Exception {
        this.resultTemplate.putString("id", REPORT_VALUE_ID);
        this.resultTemplate.putInt(REPORT_KEY_NUM_TOTAL, description.testCount());
    }

    public void testStarted(Description description) throws Exception {
        this.description = description;
        String testClass = description.getClassName();
        String testName = description.getMethodName();
        this.testResult = new Bundle(this.resultTemplate);
        this.testResult.putString(REPORT_KEY_NAME_CLASS, testClass);
        this.testResult.putString(REPORT_KEY_NAME_TEST, testName);
        this.testResult.putInt(REPORT_KEY_NUM_CURRENT, ++this.testNum);
        if (testClass != null && !testClass.equals(this.testClass)) {
            this.testResult.putString("stream", String.format("\n%s:", testClass));
            this.testClass = testClass;
        } else {
            this.testResult.putString("stream", "");
        }
        this.sendStatus(1, this.testResult);
        this.testResultCode = 0;
    }

    public void testFinished(Description description) throws Exception {
        if (this.testResultCode == 0) {
            this.testResult.putString("stream", ".");
        }
        this.sendStatus(this.testResultCode, this.testResult);
    }

    public void testFailure(Failure failure) throws Exception {
        boolean shouldCallFinish = false;
        if (!this.isAnyTestStarted()) {
            this.testStarted(failure.getDescription());
            shouldCallFinish = true;
        }
        this.testResultCode = -2;
        this.reportFailure(failure);
        if (shouldCallFinish) {
            this.testFinished(failure.getDescription());
        }
    }

    public void testAssumptionFailure(Failure failure) {
        this.testResultCode = -4;
        this.testResult.putString(REPORT_KEY_STACK, failure.getTrace());
    }

    private void reportFailure(Failure failure) {
        String trace = StackTrimmer.getTrimmedStackTrace(failure);
        this.testResult.putString(REPORT_KEY_STACK, trace);
        this.testResult.putString("stream", String.format("\nError in %s:\n%s", failure.getDescription().getDisplayName(), trace));
    }

    public void testIgnored(Description description) throws Exception {
        this.testStarted(description);
        this.testResultCode = -3;
        this.testFinished(description);
    }

    public void reportProcessCrash(Throwable t) {
        try {
            String string;
            this.testResultCode = -2;
            Failure failure = new Failure(this.description, t);
            this.testResult.putString(REPORT_KEY_STACK, failure.getTrace());
            if (this.isAnyTestStarted()) {
                String string2 = String.valueOf(this.description.getDisplayName());
                string = string2.length() != 0 ? "\nProcess crashed while executing ".concat(string2) : new String("\nProcess crashed while executing ");
            } else {
                string = "\nProcess crashed before executing the test(s)";
            }
            String errMsgPrefix = string;
            this.testResult.putString("stream", String.format(String.valueOf(errMsgPrefix).concat(":\n%s"), failure.getTrace()));
            this.testFinished(this.description);
        }
        catch (Exception e) {
            if (null == this.description) {
                Log.e((String)TAG, (String)"Failed to initialize test before process crash", (Throwable)e);
            }
            String string = this.description.getDisplayName();
            Log.e((String)TAG, (String)new StringBuilder(52 + String.valueOf(string).length()).append("Failed to mark test ").append(string).append(" as finished after process crash").toString(), (Throwable)e);
        }
    }

    @Override
    public void instrumentationRunFinished(PrintStream streamResult, Bundle resultBundle, Result junitResults) {
        new TextListener(streamResult).testRunFinished(junitResults);
    }

    private boolean isAnyTestStarted() {
        return !this.description.equals((Object)Description.EMPTY) || this.testNum != 0 || this.testClass != null;
    }
}

