/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.internal.events.client.OrchestratedInstrumentationListener;
import androidx.test.internal.events.client.TestDiscoveryEventService;
import androidx.test.internal.events.client.TestDiscoveryEventServiceConnection;
import androidx.test.internal.events.client.TestDiscoveryListener;
import androidx.test.internal.events.client.TestEventClientArgs;
import androidx.test.internal.events.client.TestEventClientConnectListener;
import androidx.test.internal.events.client.TestEventServiceConnection;
import androidx.test.internal.events.client.TestPlatformEventService;
import androidx.test.internal.events.client.TestPlatformEventServiceConnection;
import androidx.test.internal.events.client.TestPlatformListener;
import androidx.test.internal.events.client.TestRunEventService;
import androidx.test.internal.events.client.TestRunEventServiceConnection;
import androidx.test.internal.util.Checks;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.runner.notification.RunListener;

public final class TestEventClient {
    private static final String TAG = "TestEventClient";
    public static final TestEventClient NO_OP_CLIENT = new TestEventClient();
    private static TestEventServiceConnection defaultConn;
    @Nullable
    private final TestDiscoveryListener testDiscoveryListener;
    @Nullable
    private final OrchestratedInstrumentationListener notificationRunListener;
    @Nullable
    private final TestPlatformListener testPlatformListener;
    private final AtomicBoolean isConnectedToOrchestrator = new AtomicBoolean(false);

    public static TestEventClient connect(@NonNull Context context, @NonNull TestEventClientConnectListener listener, @NonNull TestEventClientArgs args) {
        Checks.checkNotNull((Object)context, (Object)"context parameter cannot be null!");
        Checks.checkNotNull((Object)listener, (Object)"listener parameter cannot be null!");
        Checks.checkNotNull((Object)args, (Object)"args parameter cannot be null!");
        if (!args.isOrchestrated) {
            return NO_OP_CLIENT;
        }
        if (!args.isPrimaryInstrProcess) {
            Log.w((String)TAG, (String)"Orchestration requested, but this isn't the primary instrumentation");
            return NO_OP_CLIENT;
        }
        TestEventServiceConnection connection = defaultConn != null ? defaultConn : TestEventClient.getConnection(listener, args);
        TestEventClient result = NO_OP_CLIENT;
        if (args.isTestDiscoveryRequested) {
            Log.v((String)TAG, (String)"Test discovery events requested");
            TestDiscoveryEventService testDiscoveryEventService = (TestDiscoveryEventService)((Object)connection);
            TestDiscoveryListener testDiscoveryListener = new TestDiscoveryListener(testDiscoveryEventService);
            result = new TestEventClient(testDiscoveryListener);
        } else if (args.isTestRunEventsRequested) {
            Log.v((String)TAG, (String)"Test run events requested");
            if (args.testPlatformMigration) {
                TestPlatformListener platformListener = new TestPlatformListener((TestPlatformEventService)((Object)connection));
                result = new TestEventClient(platformListener);
            } else {
                TestRunEventService notificationService = (TestRunEventService)((Object)connection);
                OrchestratedInstrumentationListener runListener = new OrchestratedInstrumentationListener(notificationService);
                result = new TestEventClient(runListener);
            }
        }
        connection.connect(context);
        return result;
    }

    @NonNull
    private static TestEventServiceConnection getConnection(@NonNull TestEventClientConnectListener listener, @NonNull TestEventClientArgs args) {
        if (args.orchestratorVersion == 1) {
            if (args.connectionFactory != null) {
                return args.connectionFactory.create(listener);
            }
            throw new IllegalArgumentException("Orchestrator v1 connectionFactory must be provided by TestEventClientArgs.Builder#setConnectionFactory()");
        }
        if (args.orchestratorVersion == 2) {
            if (args.isTestDiscoveryRequested) {
                return new TestDiscoveryEventServiceConnection((String)Checks.checkNotNull((Object)args.testDiscoveryService), listener);
            }
            if (args.isTestRunEventsRequested) {
                if (args.testPlatformMigration) {
                    return new TestPlatformEventServiceConnection((String)Checks.checkNotNull((Object)args.testRunEventService), listener);
                }
                return new TestRunEventServiceConnection((String)Checks.checkNotNull((Object)args.testRunEventService), listener);
            }
        }
        throw new IllegalArgumentException("TestEventClientArgs misconfiguration - can't determine which service connection to use.");
    }

    @Nullable
    public RunListener getRunListener() {
        if (this.isTestDiscoveryEnabled()) {
            return this.testDiscoveryListener;
        }
        if (this.isTestRunEventsEnabled()) {
            if (this.notificationRunListener != null) {
                return this.notificationRunListener;
            }
            return this.testPlatformListener;
        }
        return null;
    }

    private TestEventClient() {
        this.testDiscoveryListener = null;
        this.notificationRunListener = null;
        this.testPlatformListener = null;
    }

    private TestEventClient(@NonNull OrchestratedInstrumentationListener runListener) {
        Checks.checkNotNull((Object)((Object)runListener), (Object)"runListener cannot be null");
        this.testDiscoveryListener = null;
        this.notificationRunListener = runListener;
        this.testPlatformListener = null;
    }

    private TestEventClient(@NonNull TestDiscoveryListener testDiscoveryListener) {
        Checks.checkNotNull((Object)((Object)testDiscoveryListener), (Object)"testDiscovery cannot be null");
        this.testDiscoveryListener = testDiscoveryListener;
        this.notificationRunListener = null;
        this.testPlatformListener = null;
    }

    private TestEventClient(@NonNull TestPlatformListener runListener) {
        Checks.checkNotNull((Object)((Object)runListener), (Object)"runListener cannot be null");
        this.testDiscoveryListener = null;
        this.notificationRunListener = null;
        this.testPlatformListener = runListener;
    }

    public void setConnectedToOrchestrator(boolean b) {
        this.isConnectedToOrchestrator.set(b);
    }

    public static void setOrchestratorConnection(TestEventServiceConnection conn) {
        defaultConn = (TestEventServiceConnection)Checks.checkNotNull((Object)conn);
    }

    public boolean isOrchestrationServiceEnabled() {
        return this.isTestDiscoveryEnabled() || this.isTestRunEventsEnabled();
    }

    private boolean isTestDiscoveryEnabled() {
        return this.testDiscoveryListener != null;
    }

    private boolean isTestRunEventsEnabled() {
        return this.notificationRunListener != null || this.testPlatformListener != null;
    }

    public boolean reportProcessCrash(Throwable t) {
        return this.reportProcessCrash(t, TimeUnit.SECONDS.toMillis(20L));
    }

    public boolean reportProcessCrash(Throwable t, long timeoutMillis) {
        if (!this.isConnectedToOrchestrator.get()) {
            Log.w((String)TAG, (String)"Process crashed before connection to orchestrator");
            return false;
        }
        if (this.isTestRunEventsEnabled()) {
            if (this.notificationRunListener != null) {
                Log.d((String)TAG, (String)"Reporting process crashed to orchestration test run event service.");
                return this.notificationRunListener.reportProcessCrash(t, timeoutMillis);
            }
            if (this.testPlatformListener != null) {
                Log.d((String)TAG, (String)"Reporting process crash to platform test event service.");
                return this.testPlatformListener.reportProcessCrash(t);
            }
        } else if (this.isTestDiscoveryEnabled()) {
            Log.d((String)TAG, (String)"Reporting process crash to platform test discovery service.");
            return this.testDiscoveryListener.reportProcessCrash(t);
        }
        return false;
    }
}

