/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.text.TextUtils;
import androidx.test.internal.runner.RunnerArgs;
import java.util.ArrayList;
import java.util.List;

class ClassesArgTokenizer {
    private static final String TAG = "ClassesArgTokenizer";

    static List<RunnerArgs.TestArg> parse(String input) {
        ArrayList<RunnerArgs.TestArg> testargs = new ArrayList<RunnerArgs.TestArg>();
        if (!TextUtils.isEmpty((CharSequence)input)) {
            for (TokenizerState state = new ClassTokenizerState(testargs, input, 0); state != null; state = ((TokenizerState)state).parse()) {
            }
        }
        return testargs;
    }

    private ClassesArgTokenizer() {
    }

    private static class ClassTokenizerState
    extends TokenizerState {
        @Override
        TokenizerState parse() {
            while (this.pos < this.input.length()) {
                if (this.input.charAt(this.pos) == '#') {
                    String className = this.input.substring(this.startTokenPos, this.pos);
                    return new MethodTokenizerState(this.testArgs, this.input, this.pos + 1, className).parse();
                }
                if (this.input.charAt(this.pos) == ',') {
                    String className = this.input.substring(this.startTokenPos, this.pos);
                    this.testArgs.add(new RunnerArgs.TestArg(className));
                    return new ClassTokenizerState(this.testArgs, this.input, this.pos + 1);
                }
                ++this.pos;
            }
            if (this.pos > this.startTokenPos) {
                String className = this.input.substring(this.startTokenPos, this.pos);
                this.testArgs.add(new RunnerArgs.TestArg(className));
            }
            return null;
        }

        private ClassTokenizerState(List<RunnerArgs.TestArg> testArgs, String input, int pos) {
            super(testArgs, input, pos);
        }
    }

    private static abstract class TokenizerState {
        protected final List<RunnerArgs.TestArg> testArgs;
        protected final String input;
        protected final int startTokenPos;
        protected int pos;

        abstract TokenizerState parse();

        protected TokenizerState(List<RunnerArgs.TestArg> testArgs, String input, int pos) {
            this.testArgs = testArgs;
            this.input = input;
            this.pos = pos;
            this.startTokenPos = pos;
        }
    }

    private static class MethodTokenizerState
    extends TokenizerState {
        private final String className;

        @Override
        TokenizerState parse() {
            while (this.pos < this.input.length()) {
                if (this.input.charAt(this.pos) == ',') {
                    String methodName = this.input.substring(this.startTokenPos, this.pos);
                    this.testArgs.add(new RunnerArgs.TestArg(this.className, methodName));
                    return new ClassTokenizerState(this.testArgs, this.input, this.pos + 1).parse();
                }
                if (this.input.charAt(this.pos) == '[') {
                    this.pos = this.input.indexOf(93, this.pos);
                    if (this.pos <= 0) {
                        String string = this.input;
                        throw new IllegalStateException("Could not find closing param ] in input " + string);
                    }
                }
                if (this.input.charAt(this.pos) == '(') {
                    this.pos = this.input.indexOf(41, this.pos);
                    if (this.pos <= 0) {
                        String string = this.input;
                        throw new IllegalStateException("Could not find closing param ) in input " + string);
                    }
                }
                ++this.pos;
            }
            if (this.pos > this.startTokenPos) {
                String methodName = this.input.substring(this.startTokenPos, this.pos);
                this.testArgs.add(new RunnerArgs.TestArg(this.className, methodName));
            }
            return null;
        }

        protected MethodTokenizerState(List<RunnerArgs.TestArg> testArgs, String input, int pos, String className) {
            super(testArgs, input, pos);
            this.className = className;
        }
    }
}

