/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.util.Log;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class LogRunListener
extends RunListener {
    private static final String TAG = "TestRunner";

    public void testAssumptionFailure(Failure failure) {
        String string = failure.getDescription().getDisplayName();
        Log.e((String)TAG, (String)("assumption failed: " + string));
        Log.e((String)TAG, (String)"----- begin exception -----");
        Log.e((String)TAG, (String)failure.getTrace());
        Log.e((String)TAG, (String)"----- end exception -----");
    }

    public void testFailure(Failure failure) throws Exception {
        String string = failure.getDescription().getDisplayName();
        Log.e((String)TAG, (String)("failed: " + string));
        Log.e((String)TAG, (String)"----- begin exception -----");
        Log.e((String)TAG, (String)failure.getTrace());
        Log.e((String)TAG, (String)"----- end exception -----");
    }

    public void testFinished(Description description) throws Exception {
        String string = description.getDisplayName();
        Log.i((String)TAG, (String)("finished: " + string));
    }

    public void testIgnored(Description description) throws Exception {
        String string = description.getDisplayName();
        Log.i((String)TAG, (String)("ignored: " + string));
    }

    public void testRunFinished(Result result) throws Exception {
        Log.i((String)TAG, (String)String.format("run finished: %d tests, %d failed, %d ignored", result.getRunCount(), result.getFailureCount(), result.getIgnoreCount()));
    }

    public void testRunStarted(Description description) throws Exception {
        Log.i((String)TAG, (String)String.format("run started: %d tests", description.testCount()));
    }

    public void testStarted(Description description) throws Exception {
        String string = description.getDisplayName();
        Log.i((String)TAG, (String)("started: " + string));
    }
}

