/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.app.Instrumentation;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.runner.coverage.InstrumentationCoverageReporter;
import androidx.test.internal.runner.listener.InstrumentationRunListener;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.platform.io.PlatformTestStorageRegistry;
import java.io.PrintStream;
import org.junit.runner.Result;

public class CoverageListener
extends InstrumentationRunListener {
    private static final String REPORT_KEY_COVERAGE_PATH = "coverageFilePath";
    private final String coverageFilePath;
    private PlatformTestStorage runnerIO;
    private InstrumentationCoverageReporter coverageReporter;

    public CoverageListener(@Nullable String customCoverageFilePath) {
        this(customCoverageFilePath, PlatformTestStorageRegistry.getInstance());
    }

    @VisibleForTesting
    CoverageListener(@Nullable String customCoverageFilePath, InstrumentationCoverageReporter coverageReporter) {
        this.coverageFilePath = customCoverageFilePath;
        this.coverageReporter = coverageReporter;
    }

    public CoverageListener(@Nullable String customCoverageFilePath, PlatformTestStorage runnerIO) {
        this.coverageFilePath = customCoverageFilePath;
        this.runnerIO = runnerIO;
    }

    @Override
    public void instrumentationRunFinished(PrintStream streamResult, Bundle resultBundle, Result junitResults) {
        String actualCoveragePath = this.coverageReporter.generateCoverageReport(this.coverageFilePath, streamResult);
        resultBundle.putString(REPORT_KEY_COVERAGE_PATH, actualCoveragePath);
    }

    @Override
    public void setInstrumentation(Instrumentation instr) {
        super.setInstrumentation(instr);
        this.coverageReporter = new InstrumentationCoverageReporter(this.getInstrumentation(), this.runnerIO);
    }
}

