/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.orchestrator.listeners.result;

import java.util.Arrays;
import java.util.Map;

public class TestResult {
    private TestStatus status = TestStatus.INCOMPLETE;
    private String stackTrace;
    private Map<String, String> metrics;
    private long startTime = System.currentTimeMillis();
    private long endTime = 0L;

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.metrics, this.stackTrace, this.status});
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TestStatus getStatus() {
        return this.status;
    }

    public TestResult setStatus(TestStatus status) {
        this.status = status;
        return this;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Map<String, String> getMetrics() {
        return this.metrics;
    }

    public void setEndTime(long currentTimeMillis) {
        this.endTime = currentTimeMillis;
    }

    public void setMetrics(Map<String, String> metrics) {
        this.metrics = metrics;
    }

    public void setStackTrace(String trace) {
        this.stackTrace = trace;
    }

    private static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestResult other = (TestResult)obj;
        return TestResult.equal(this.metrics, other.metrics) && TestResult.equal(this.stackTrace, other.stackTrace) && TestResult.equal((Object)this.status, (Object)other.status);
    }

    public static enum TestStatus {
        FAILURE,
        PASSED,
        INCOMPLETE,
        ASSUMPTION_FAILURE,
        IGNORED;

    }
}

