/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.app.Instrumentation;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.runner.ClassesArgTokenizer;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.platform.io.PlatformTestStorageRegistry;
import androidx.test.runner.lifecycle.ApplicationLifecycleCallback;
import androidx.test.runner.screenshot.ScreenCaptureProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.RunnerBuilder;

public class RunnerArgs {
    private static final String LOG_TAG = "RunnerArgs";
    static final String ARGUMENT_TEST_CLASS = "class";
    static final String ARGUMENT_CLASSPATH_TO_SCAN = "classpathToScan";
    static final String ARGUMENT_NOT_TEST_CLASS = "notClass";
    static final String ARGUMENT_TEST_SIZE = "size";
    static final String ARGUMENT_LOG_ONLY = "log";
    static final String ARGUMENT_ANNOTATION = "annotation";
    static final String ARGUMENT_NOT_ANNOTATION = "notAnnotation";
    static final String ARGUMENT_NUM_SHARDS = "numShards";
    static final String ARGUMENT_SHARD_INDEX = "shardIndex";
    static final String ARGUMENT_DELAY_IN_MILLIS = "delay_msec";
    static final String ARGUMENT_COVERAGE = "coverage";
    static final String ARGUMENT_COVERAGE_PATH = "coverageFile";
    static final String ARGUMENT_SUITE_ASSIGNMENT = "suiteAssignment";
    static final String ARGUMENT_DEBUG = "debug";
    static final String ARGUMENT_LISTENER = "listener";
    static final String ARGUMENT_FILTER = "filter";
    static final String ARGUMENT_RUNNER_BUILDER = "runnerBuilder";
    static final String ARGUMENT_TEST_PACKAGE = "package";
    static final String ARGUMENT_NOT_TEST_PACKAGE = "notPackage";
    static final String ARGUMENT_TIMEOUT = "timeout_msec";
    static final String ARGUMENT_TEST_FILE = "testFile";
    static final String ARGUMENT_NOT_TEST_FILE = "notTestFile";
    static final String ARGUMENT_DISABLE_ANALYTICS = "disableAnalytics";
    static final String ARGUMENT_APP_LISTENER = "appListener";
    static final String ARGUMENT_CLASS_LOADER = "classLoader";
    static final String ARGUMENT_REMOTE_INIT_METHOD = "remoteMethod";
    static final String ARGUMENT_TARGET_PROCESS = "targetProcess";
    static final String ARGUMENT_SCREENSHOT_PROCESSORS = "screenCaptureProcessors";
    static final String ARGUMENT_ORCHESTRATOR_SERVICE = "orchestratorService";
    static final String ARGUMENT_LIST_TESTS_FOR_ORCHESTRATOR = "listTestsForOrchestrator";
    static final String ARGUMENT_ORCHESTRATOR_DISCOVERY_SERVICE = "testDiscoveryService";
    static final String ARGUMENT_ORCHESTRATOR_RUN_EVENTS_SERVICE = "testRunEventsService";
    static final String ARGUMENT_TEST_PLATFORM_MIGRATION = "temporary_testPlatformMigration";
    public static final String ARGUMENT_USE_TEST_STORAGE_SERVICE = "useTestStorageService";
    static final String ARGUMENT_SHELL_EXEC_BINDER_KEY = "shellExecBinderKey";
    static final String ARGUMENT_RUN_LISTENER_NEW_ORDER = "newRunListenerMode";
    static final String ARGUMENT_TESTS_REGEX = "tests_regex";
    private static final String CLASS_SEPARATOR = ",";
    private static final String CLASSPATH_SEPARATOR = ":";
    private static final char METHOD_SEPARATOR = '#';
    public final boolean debug;
    public final boolean suiteAssignment;
    public final boolean codeCoverage;
    public final String codeCoveragePath;
    public final int delayInMillis;
    public final boolean logOnly;
    public final List<String> testPackages;
    public final List<String> notTestPackages;
    public final String testSize;
    public final List<String> annotations;
    public final List<String> notAnnotations;
    public final long testTimeout;
    public final List<RunListener> listeners;
    public final List<Filter> filters;
    public final List<Class<? extends RunnerBuilder>> runnerBuilderClasses;
    public final List<TestArg> tests;
    public final List<TestArg> notTests;
    public final int numShards;
    public final int shardIndex;
    public final boolean disableAnalytics;
    public final List<ApplicationLifecycleCallback> appListeners;
    public final ClassLoader classLoader;
    public final Set<String> classpathToScan;
    public final TestArg remoteMethod;
    public final String targetProcess;
    public final List<ScreenCaptureProcessor> screenCaptureProcessors;
    public final String orchestratorService;
    public final boolean listTestsForOrchestrator;
    public final String testDiscoveryService;
    public final String testRunEventsService;
    public final boolean useTestStorageService;
    public final String shellExecBinderKey;
    public final boolean newRunListenerMode;
    public final String testsRegEx;
    public final boolean testPlatformMigration;

    private RunnerArgs(Builder builder) {
        this.debug = builder.debug;
        this.suiteAssignment = builder.suiteAssignment;
        this.codeCoverage = builder.codeCoverage;
        this.codeCoveragePath = builder.codeCoveragePath;
        this.delayInMillis = builder.delayInMillis;
        this.logOnly = builder.logOnly;
        this.testPackages = builder.testPackages;
        this.notTestPackages = builder.notTestPackages;
        this.testSize = builder.testSize;
        this.annotations = Collections.unmodifiableList(builder.annotations);
        this.notAnnotations = Collections.unmodifiableList(builder.notAnnotations);
        this.testTimeout = builder.testTimeout;
        this.listeners = Collections.unmodifiableList(builder.listeners);
        this.filters = Collections.unmodifiableList(builder.filters);
        this.runnerBuilderClasses = Collections.unmodifiableList(builder.runnerBuilderClasses);
        this.tests = Collections.unmodifiableList(builder.tests);
        this.notTests = Collections.unmodifiableList(builder.notTests);
        this.numShards = builder.numShards;
        this.shardIndex = builder.shardIndex;
        this.disableAnalytics = builder.disableAnalytics;
        this.appListeners = Collections.unmodifiableList(builder.appListeners);
        this.classLoader = builder.classLoader;
        this.classpathToScan = builder.classpathToScan;
        this.remoteMethod = builder.remoteMethod;
        this.orchestratorService = builder.orchestratorService;
        this.listTestsForOrchestrator = builder.listTestsForOrchestrator;
        this.testDiscoveryService = builder.testDiscoveryService;
        this.testRunEventsService = builder.testRunEventsService;
        this.useTestStorageService = builder.useTestStorageService;
        this.screenCaptureProcessors = Collections.unmodifiableList(builder.screenCaptureProcessors);
        this.targetProcess = builder.targetProcess;
        this.shellExecBinderKey = builder.shellExecBinderKey;
        this.newRunListenerMode = builder.newRunListenerMode;
        this.testsRegEx = builder.testsRegEx;
        this.testPlatformMigration = builder.testPlatformMigration;
    }

    public static class Builder {
        private boolean debug = false;
        private boolean suiteAssignment = false;
        private boolean codeCoverage = false;
        private String codeCoveragePath = null;
        private int delayInMillis = -1;
        private boolean logOnly = false;
        private List<String> testPackages = new ArrayList<String>();
        private List<String> notTestPackages = new ArrayList<String>();
        private String testSize = null;
        private final List<String> annotations = new ArrayList<String>();
        private final List<String> notAnnotations = new ArrayList<String>();
        private long testTimeout = -1L;
        private List<RunListener> listeners = new ArrayList<RunListener>();
        private List<Filter> filters = new ArrayList<Filter>();
        private List<Class<? extends RunnerBuilder>> runnerBuilderClasses = new ArrayList<Class<? extends RunnerBuilder>>();
        private List<TestArg> tests = new ArrayList<TestArg>();
        private List<TestArg> notTests = new ArrayList<TestArg>();
        private int numShards = 0;
        private int shardIndex = 0;
        private boolean disableAnalytics = false;
        private List<ApplicationLifecycleCallback> appListeners = new ArrayList<ApplicationLifecycleCallback>();
        private ClassLoader classLoader = null;
        private Set<String> classpathToScan = new HashSet<String>();
        private TestArg remoteMethod = null;
        private String orchestratorService = null;
        private boolean listTestsForOrchestrator = false;
        private String testDiscoveryService = null;
        private String testRunEventsService = null;
        private boolean useTestStorageService = false;
        private String targetProcess = null;
        private List<ScreenCaptureProcessor> screenCaptureProcessors = new ArrayList<ScreenCaptureProcessor>();
        public String shellExecBinderKey;
        private boolean newRunListenerMode = false;
        private String testsRegEx = null;
        private boolean testPlatformMigration = false;
        private final PlatformTestStorage testStorage;

        public Builder() {
            this(PlatformTestStorageRegistry.getInstance());
        }

        Builder(PlatformTestStorage testStorage) {
            this.testStorage = testStorage;
        }

        public Builder fromBundle(Instrumentation instr, Bundle bundle) {
            this.debug = Builder.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_DEBUG));
            this.useTestStorageService = Builder.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_USE_TEST_STORAGE_SERVICE));
            this.delayInMillis = Builder.parseUnsignedInt(bundle.get(RunnerArgs.ARGUMENT_DELAY_IN_MILLIS), RunnerArgs.ARGUMENT_DELAY_IN_MILLIS);
            this.tests.addAll(this.parseTestClasses(bundle.getString(RunnerArgs.ARGUMENT_TEST_CLASS)));
            this.notTests.addAll(this.parseTestClasses(bundle.getString(RunnerArgs.ARGUMENT_NOT_TEST_CLASS)));
            this.testPackages.addAll(Builder.parseTestPackages(bundle.getString(RunnerArgs.ARGUMENT_TEST_PACKAGE)));
            this.notTestPackages.addAll(Builder.parseTestPackages(bundle.getString(RunnerArgs.ARGUMENT_NOT_TEST_PACKAGE)));
            TestFileArgs testFileArgs = this.parseTestFile(instr, this.useTestStorageService, bundle.getString(RunnerArgs.ARGUMENT_TEST_FILE));
            this.tests.addAll(testFileArgs.tests);
            this.testPackages.addAll(testFileArgs.packages);
            TestFileArgs notTestFileArgs = this.parseTestFile(instr, this.useTestStorageService, bundle.getString(RunnerArgs.ARGUMENT_NOT_TEST_FILE));
            this.notTests.addAll(notTestFileArgs.tests);
            this.notTestPackages.addAll(notTestFileArgs.packages);
            this.listeners.addAll(this.parseLoadAndInstantiateClasses(bundle.getString(RunnerArgs.ARGUMENT_LISTENER), RunListener.class, null));
            this.filters.addAll(this.parseLoadAndInstantiateClasses(bundle.getString(RunnerArgs.ARGUMENT_FILTER), Filter.class, bundle));
            this.runnerBuilderClasses.addAll(this.parseAndLoadClasses(bundle.getString(RunnerArgs.ARGUMENT_RUNNER_BUILDER), RunnerBuilder.class));
            this.testSize = bundle.getString(RunnerArgs.ARGUMENT_TEST_SIZE);
            this.annotations.addAll(Builder.parseStrings(bundle.getString(RunnerArgs.ARGUMENT_ANNOTATION)));
            this.notAnnotations.addAll(Builder.parseStrings(bundle.getString(RunnerArgs.ARGUMENT_NOT_ANNOTATION)));
            this.testTimeout = Builder.parseUnsignedLong(bundle.getString(RunnerArgs.ARGUMENT_TIMEOUT), RunnerArgs.ARGUMENT_TIMEOUT);
            this.numShards = Builder.parseUnsignedInt(bundle.get(RunnerArgs.ARGUMENT_NUM_SHARDS), RunnerArgs.ARGUMENT_NUM_SHARDS);
            this.shardIndex = Builder.parseUnsignedInt(bundle.get(RunnerArgs.ARGUMENT_SHARD_INDEX), RunnerArgs.ARGUMENT_SHARD_INDEX);
            this.logOnly = Builder.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_LOG_ONLY));
            this.disableAnalytics = Builder.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_DISABLE_ANALYTICS));
            this.appListeners.addAll(this.parseLoadAndInstantiateClasses(bundle.getString(RunnerArgs.ARGUMENT_APP_LISTENER), ApplicationLifecycleCallback.class, null));
            this.codeCoverage = Builder.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_COVERAGE));
            this.codeCoveragePath = bundle.getString(RunnerArgs.ARGUMENT_COVERAGE_PATH);
            this.suiteAssignment = Builder.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_SUITE_ASSIGNMENT));
            this.classLoader = this.parseLoadAndInstantiateClass(bundle.getString(RunnerArgs.ARGUMENT_CLASS_LOADER), ClassLoader.class);
            this.classpathToScan = Builder.parseClasspath(bundle.getString(RunnerArgs.ARGUMENT_CLASSPATH_TO_SCAN));
            if (bundle.containsKey(RunnerArgs.ARGUMENT_REMOTE_INIT_METHOD)) {
                this.remoteMethod = Builder.parseTestClass(bundle.getString(RunnerArgs.ARGUMENT_REMOTE_INIT_METHOD));
            }
            this.orchestratorService = bundle.getString(RunnerArgs.ARGUMENT_ORCHESTRATOR_SERVICE);
            this.listTestsForOrchestrator = Builder.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_LIST_TESTS_FOR_ORCHESTRATOR));
            this.testDiscoveryService = bundle.getString(RunnerArgs.ARGUMENT_ORCHESTRATOR_DISCOVERY_SERVICE);
            this.testRunEventsService = bundle.getString(RunnerArgs.ARGUMENT_ORCHESTRATOR_RUN_EVENTS_SERVICE);
            this.targetProcess = bundle.getString(RunnerArgs.ARGUMENT_TARGET_PROCESS);
            this.screenCaptureProcessors.addAll(this.parseLoadAndInstantiateClasses(bundle.getString(RunnerArgs.ARGUMENT_SCREENSHOT_PROCESSORS), ScreenCaptureProcessor.class, null));
            this.shellExecBinderKey = bundle.getString(RunnerArgs.ARGUMENT_SHELL_EXEC_BINDER_KEY);
            this.newRunListenerMode = Builder.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_RUN_LISTENER_NEW_ORDER));
            this.testsRegEx = bundle.getString(RunnerArgs.ARGUMENT_TESTS_REGEX);
            this.testPlatformMigration = Builder.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_TEST_PLATFORM_MIGRATION));
            return this;
        }

        private TestFileArgs parseTestFile(Instrumentation instr, boolean useStorageService, String filePath) {
            TestFileArgs testFileArgs;
            block17: {
                if (filePath == null) {
                    return new TestFileArgs();
                }
                if (useStorageService) {
                    TestFileArgs testFileArgs2;
                    String localFilePath = filePath.startsWith("/") ? filePath.substring(1) : filePath;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.testStorage.openInputFile(localFilePath)));
                    try {
                        testFileArgs2 = this.parseFromFileStream(reader);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            Log.w((String)RunnerArgs.LOG_TAG, (String)String.format("Could not read test file from TestStorage %s. Attempting to read from local file system", filePath), (Throwable)e);
                        }
                    }
                    reader.close();
                    return testFileArgs2;
                }
                BufferedReader reader = this.openFile(instr, filePath);
                try {
                    testFileArgs = this.parseFromFileStream(reader);
                    if (reader == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Could not read test file " + filePath, e);
                    }
                }
                reader.close();
            }
            return testFileArgs;
        }

        public Builder fromManifest(Instrumentation instr) {
            PackageManager pm = instr.getContext().getPackageManager();
            try {
                InstrumentationInfo instrInfo = pm.getInstrumentationInfo(instr.getComponentName(), 128);
                Bundle b = instrInfo.metaData;
                if (b == null) {
                    return this;
                }
                return this.fromBundle(instr, b);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.wtf((String)RunnerArgs.LOG_TAG, (String)String.format("Could not find component %s", instr.getComponentName()));
                return this;
            }
        }

        private static List<String> parseStrings(String value) {
            if (value == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(value.split(RunnerArgs.CLASS_SEPARATOR));
        }

        private static boolean parseBoolean(String booleanValue) {
            return booleanValue != null && Boolean.parseBoolean(booleanValue);
        }

        private static int parseUnsignedInt(Object value, String name) {
            if (value != null) {
                int intValue = Integer.parseInt(value.toString());
                if (intValue < 0) {
                    throw new NumberFormatException(name + " can not be negative");
                }
                return intValue;
            }
            return -1;
        }

        private static long parseUnsignedLong(Object value, String name) {
            if (value != null) {
                long longValue = Long.parseLong(value.toString());
                if (longValue < 0L) {
                    throw new NumberFormatException(name + " can not be negative");
                }
                return longValue;
            }
            return -1L;
        }

        private static List<String> parseTestPackages(String packagesArg) {
            ArrayList<String> packages = new ArrayList<String>();
            if (packagesArg != null) {
                for (String packageName : packagesArg.split(RunnerArgs.CLASS_SEPARATOR)) {
                    packages.add(packageName);
                }
            }
            return packages;
        }

        private List<TestArg> parseTestClasses(String classesArg) {
            return ClassesArgTokenizer.parse(classesArg);
        }

        private static Set<String> parseClasspath(String classpath) {
            if (classpath == null || classpath.isEmpty()) {
                return new HashSet<String>();
            }
            return new HashSet<String>(Arrays.asList(classpath.split(RunnerArgs.CLASSPATH_SEPARATOR, -1)));
        }

        private static TestArg parseTestClass(String testClassName) {
            if (TextUtils.isEmpty((CharSequence)testClassName)) {
                return null;
            }
            int methodSeparatorIndex = testClassName.indexOf(35);
            if (methodSeparatorIndex > 0) {
                String testMethodName = testClassName.substring(methodSeparatorIndex + 1);
                testClassName = testClassName.substring(0, methodSeparatorIndex);
                return new TestArg(testClassName, testMethodName);
            }
            return new TestArg(testClassName);
        }

        private TestFileArgs parseFromFileStream(BufferedReader reader) throws IOException {
            String line;
            TestFileArgs args = new TestFileArgs();
            while ((line = reader.readLine()) != null) {
                if (Builder.isClassOrMethod(line)) {
                    args.tests.add(Builder.parseTestClass(line));
                    continue;
                }
                args.packages.addAll(Builder.parseTestPackages(line));
            }
            return args;
        }

        private BufferedReader openFile(Instrumentation instr, String filePath) throws IOException {
            boolean isInstantApp = Build.VERSION.SDK_INT >= 26 && instr.getContext().getPackageManager().isInstantApp();
            return new BufferedReader(isInstantApp ? new InputStreamReader((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(instr.getUiAutomation().executeShellCommand("cat " + filePath))) : new FileReader(new File(filePath)));
        }

        @VisibleForTesting
        static boolean isClassOrMethod(String line) {
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c != '#' && !Character.isUpperCase(c)) continue;
                return true;
            }
            return false;
        }

        private <T> List<T> parseLoadAndInstantiateClasses(String classString, Class<T> type, Bundle bundle) {
            ArrayList objects = new ArrayList();
            if (classString != null) {
                for (String className : classString.split(RunnerArgs.CLASS_SEPARATOR)) {
                    this.loadClassByNameInstantiateAndAdd(objects, className, type, bundle);
                }
            }
            return objects;
        }

        private <T> T parseLoadAndInstantiateClass(String classString, Class<T> type) {
            List<T> classLoaders = this.parseLoadAndInstantiateClasses(classString, type, null);
            if (!classLoaders.isEmpty()) {
                if (classLoaders.size() > 1) {
                    throw new IllegalArgumentException(String.format("Expected 1 class loader, %d given", classLoaders.size()));
                }
                return classLoaders.get(0);
            }
            return null;
        }

        private <T> void loadClassByNameInstantiateAndAdd(List<T> objects, String className, Class<T> type, Bundle bundle) {
            if (className == null || className.length() == 0) {
                return;
            }
            try {
                Object[] arguments;
                Constructor<?> constructor;
                Class<?> klass = Class.forName(className);
                try {
                    constructor = klass.getConstructor(new Class[0]);
                    arguments = new Object[]{};
                }
                catch (NoSuchMethodException nsme1) {
                    if (bundle != null) {
                        try {
                            constructor = klass.getConstructor(Bundle.class);
                            arguments = new Object[]{bundle};
                        }
                        catch (NoSuchMethodException nsme2) {
                            nsme2.initCause(nsme1);
                            throw nsme2;
                        }
                    }
                    throw nsme1;
                }
                constructor.setAccessible(true);
                Object instance = constructor.newInstance(arguments);
                objects.add(instance);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find extra class " + className);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Must have no argument constructor for class " + className);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(className + " does not extend " + type.getName());
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Failed to create: " + className, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to create: " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to create listener: " + className, e);
            }
        }

        private <T> List<Class<? extends T>> parseAndLoadClasses(String classString, Class<T> type) {
            ArrayList<Class<? extends T>> classes = new ArrayList<Class<? extends T>>();
            if (classString != null) {
                for (String className : classString.split(RunnerArgs.CLASS_SEPARATOR)) {
                    this.loadClassByNameAndAdd(classes, className, type);
                }
            }
            return classes;
        }

        private <T> void loadClassByNameAndAdd(List<Class<? extends T>> classes, String className, Class<T> type) {
            if (null == className || className.length() == 0) {
                return;
            }
            try {
                Class<?> klass = Class.forName(className);
                if (!type.isAssignableFrom(klass)) {
                    throw new IllegalArgumentException(className + " does not extend " + type.getName());
                }
                Class<?> castClass = klass;
                classes.add(castClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find extra class " + className);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(className + " does not extend " + type.getName());
            }
        }

        public RunnerArgs build() {
            return new RunnerArgs(this);
        }
    }

    private static final class TestFileArgs {
        private final List<TestArg> tests = new ArrayList<TestArg>();
        private final List<String> packages = new ArrayList<String>();

        private TestFileArgs() {
        }
    }

    public static class TestArg {
        public final String testClassName;
        public final String methodName;

        TestArg(String className, String methodName) {
            this.testClassName = className;
            this.methodName = methodName;
        }

        TestArg(String className) {
            this(className, null);
        }

        public String toString() {
            return this.methodName != null ? this.testClassName + '#' + this.methodName : this.testClassName;
        }
    }
}

