/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit4;

import android.util.Log;
import androidx.test.internal.runner.EmptyTestRunner;
import androidx.test.internal.runner.junit4.AndroidJUnit4ClassRunner;
import androidx.test.internal.util.AndroidRunnerParams;
import java.lang.reflect.Method;
import org.junit.Test;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.runner.Runner;

public class AndroidJUnit4Builder
extends JUnit4Builder {
    private static final String TAG = "AndroidJUnit4Builder";
    private final AndroidRunnerParams androidRunnerParams;

    public AndroidJUnit4Builder(AndroidRunnerParams runnerParams) {
        this.androidRunnerParams = runnerParams;
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        try {
            if (!AndroidJUnit4Builder.hasTestMethods(testClass)) {
                if (testClass.getClassLoader() != Test.class.getClassLoader()) {
                    Class clazz;
                    try {
                        clazz = Class.forName("org.junit.Test", false, testClass.getClassLoader());
                    }
                    catch (Throwable e) {
                        clazz = Test.class;
                    }
                    if (!clazz.equals(Test.class)) {
                        return new EmptyTestRunner(testClass, (Throwable)new IllegalStateException("org.junit.Test in custom classloader " + testClass.getClassLoader() + " differs from org.junit.Test in the JUnit runner's classloader. This causes JUnit to not be able to find the tests to run."));
                    }
                }
                return new EmptyTestRunner(testClass);
            }
            return new AndroidJUnit4ClassRunner(testClass, this.androidRunnerParams);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Error constructing runner", (Throwable)e);
            throw e;
        }
    }

    private static boolean hasTestMethods(Class<?> testClass) {
        boolean hasTestMethods = false;
        try {
            for (Method testMethod : testClass.getMethods()) {
                if (!testMethod.isAnnotationPresent(Test.class)) continue;
                hasTestMethods = true;
                break;
            }
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)String.format("%s in hasTestMethods for %s", t.toString(), testClass.getName()));
            return false;
        }
        return hasTestMethods;
    }
}

