/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.platform;

import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.ErrorInfo;
import androidx.test.services.events.TestCaseInfo;
import androidx.test.services.events.TimeStamp;
import androidx.test.services.events.platform.TestPlatformEvent;

public class TestCaseErrorEvent
extends TestPlatformEvent {
    @NonNull
    public final TestCaseInfo testCase;
    @NonNull
    public final ErrorInfo error;
    @NonNull
    public final TimeStamp timeStamp;

    public TestCaseErrorEvent(@NonNull TestCaseInfo testCase, @NonNull ErrorInfo error, @NonNull TimeStamp timeStamp) {
        this.testCase = (TestCaseInfo)Checks.checkNotNull((Object)testCase, (Object)"testCase cannot be null");
        this.error = (ErrorInfo)Checks.checkNotNull((Object)error, (Object)"error cannot be null");
        this.timeStamp = (TimeStamp)Checks.checkNotNull((Object)timeStamp, (Object)"timeStamp cannot be null");
    }

    TestCaseErrorEvent(Parcel source) {
        this.testCase = new TestCaseInfo(source);
        this.error = new ErrorInfo(source);
        this.timeStamp = new TimeStamp(source);
    }

    @Override
    TestPlatformEvent.EventType instanceType() {
        return TestPlatformEvent.EventType.TEST_CASE_ERROR;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        this.testCase.writeToParcel(parcel, i);
        this.error.writeToParcel(parcel, i);
        this.timeStamp.writeToParcel(parcel, i);
    }
}

