/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.orchestrator.callback;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface OrchestratorCallback
extends IInterface {
    public static final String DESCRIPTOR = "androidx.test.orchestrator.callback.OrchestratorCallback";

    public void addTest(String var1) throws RemoteException;

    public void sendTestNotification(Bundle var1) throws RemoteException;

    public static class _Parcel {
        private static <T> T readTypedObject(Parcel parcel, Parcelable.Creator<T> c) {
            if (parcel.readInt() != 0) {
                return (T)c.createFromParcel(parcel);
            }
            return null;
        }

        private static <T extends Parcelable> void writeTypedObject(Parcel parcel, T value, int parcelableFlags) {
            if (value != null) {
                parcel.writeInt(1);
                value.writeToParcel(parcel, parcelableFlags);
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements OrchestratorCallback {
        static final int TRANSACTION_addTest = 1;
        static final int TRANSACTION_sendTestNotification = 2;

        public Stub() {
            this.attachInterface(this, OrchestratorCallback.DESCRIPTOR);
        }

        public static OrchestratorCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(OrchestratorCallback.DESCRIPTOR);
            if (iin != null && iin instanceof OrchestratorCallback) {
                return (OrchestratorCallback)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = OrchestratorCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    this.addTest(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    Bundle _arg0 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.sendTestNotification(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements OrchestratorCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return OrchestratorCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addTest(String test) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(OrchestratorCallback.DESCRIPTOR);
                    _data.writeString(test);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendTestNotification(Bundle bundle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(OrchestratorCallback.DESCRIPTOR);
                    _Parcel.writeTypedObject(_data, (Parcelable)bundle, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements OrchestratorCallback {
        @Override
        public void addTest(String test) throws RemoteException {
        }

        @Override
        public void sendTestNotification(Bundle bundle) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

