/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.AnnotationInfo;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TestCaseInfo
implements Parcelable {
    @NonNull
    public final String className;
    @NonNull
    public final String methodName;
    @NonNull
    public final List<AnnotationInfo> methodAnnotations;
    @NonNull
    public final List<AnnotationInfo> classAnnotations;
    public static final Parcelable.Creator<TestCaseInfo> CREATOR = new Parcelable.Creator<TestCaseInfo>(){

        public TestCaseInfo createFromParcel(Parcel source) {
            return new TestCaseInfo(source);
        }

        public TestCaseInfo[] newArray(int size) {
            return new TestCaseInfo[size];
        }
    };

    public TestCaseInfo(@NonNull Parcel source) {
        Checks.checkNotNull((Object)source, (Object)"source cannot be null");
        this.className = (String)Checks.checkNotNull((Object)source.readString(), (Object)"className cannot be null");
        this.methodName = (String)Checks.checkNotNull((Object)source.readString(), (Object)"methodName cannot be null");
        this.methodAnnotations = new ArrayList<AnnotationInfo>();
        source.readTypedList(this.methodAnnotations, AnnotationInfo.CREATOR);
        this.classAnnotations = new ArrayList<AnnotationInfo>();
        source.readTypedList(this.classAnnotations, AnnotationInfo.CREATOR);
    }

    public TestCaseInfo(@NonNull String className, @NonNull String methodName, @NonNull List<AnnotationInfo> methodAnnotations, @NonNull List<AnnotationInfo> classAnnotations) {
        this.className = (String)Checks.checkNotNull((Object)className, (Object)"className cannot be null");
        this.methodName = (String)Checks.checkNotNull((Object)methodName, (Object)"methodName cannot be null");
        this.classAnnotations = (List)Checks.checkNotNull(classAnnotations, (Object)"classAnnotations cannot be null");
        this.methodAnnotations = (List)Checks.checkNotNull(methodAnnotations, (Object)"methodAnnotations cannot be null");
    }

    @NonNull
    public String getClassAndMethodName() {
        return this.className + "#" + this.methodName;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.className);
        parcel.writeString(this.methodName);
        parcel.writeTypedList(this.methodAnnotations);
        parcel.writeTypedList(this.classAnnotations);
    }
}

