/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.TestCaseInfo;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TestRunInfo
implements Parcelable {
    @NonNull
    public final String testRunName;
    @NonNull
    public final List<TestCaseInfo> testCases;
    public static final Parcelable.Creator<TestRunInfo> CREATOR = new Parcelable.Creator<TestRunInfo>(){

        public TestRunInfo createFromParcel(Parcel source) {
            return new TestRunInfo(source);
        }

        public TestRunInfo[] newArray(int size) {
            return new TestRunInfo[size];
        }
    };

    public TestRunInfo(@NonNull String testRunName, @NonNull List<TestCaseInfo> testCases) {
        this.testRunName = (String)Checks.checkNotNull((Object)testRunName, (Object)"testRunName cannot be null");
        this.testCases = (List)Checks.checkNotNull(testCases, (Object)"testCases cannot be null");
    }

    public TestRunInfo(@NonNull Parcel source) {
        Checks.checkNotNull((Object)source, (Object)"source cannot be null");
        this.testRunName = (String)Checks.checkNotNull((Object)source.readString(), (Object)"className cannot be null");
        this.testCases = new ArrayList<TestCaseInfo>();
        source.readTypedList(this.testCases, TestCaseInfo.CREATOR);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.testRunName);
        parcel.writeTypedList(this.testCases);
    }
}

