/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.internal;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.services.events.internal.Throwables;
import org.junit.runner.notification.Failure;

public final class StackTrimmer {
    private static final String TAG = "StackTrimmer";
    @VisibleForTesting
    static final int MAX_TRACE_SIZE = 65536;

    private StackTrimmer() {
    }

    public static String getTrimmedStackTrace(Failure failure) {
        String trace = Throwables.getTrimmedStackTrace(failure.getException());
        if (trace.length() > 65536) {
            Log.w((String)TAG, (String)String.format("Stack trace too long, trimmed to first %s characters.", 65536));
            trace = trace.substring(0, 65536) + "\n";
        }
        return trace;
    }

    public static String getTrimmedMessage(Failure failure) {
        String message = failure.getMessage();
        if (message != null && message.length() > 65536) {
            Log.w((String)TAG, (String)String.format("Message too long, trimmed to first %s characters.", 65536));
            message = message.substring(0, 65536) + "\n";
        }
        return message;
    }

    public static String getTrimmedSummary(String summary) {
        if (summary != null && summary.length() > 65536) {
            Log.w((String)TAG, (String)String.format("Content too long, trimmed to first %s characters.", 65536));
            summary = summary.substring(0, 65536) + "\n";
        }
        return summary;
    }
}

